/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageMonitor;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.TestPartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.impl.steps.BackupApiRequestHandlerStep;
import io.camunda.zeebe.broker.transport.backupapi.BackupApiRequestHandler;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamWriter;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.testing.TestActorFuture;
import io.camunda.zeebe.scheduler.testing.TestConcurrencyControl;
import io.camunda.zeebe.transport.impl.AtomixServerTransport;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
final class BackupApiRequestHandlerStepTest {
    @Mock
    AtomixServerTransport serverTransport;
    @Mock
    LogStream logStream;
    @Mock
    LogStreamWriter logStreamWriter;
    @Mock
    DiskSpaceUsageMonitor diskSpaceUsageMonitor;
    @Mock
    ActorSchedulingService actorSchedulingService;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    BrokerCfg brokerCfg;
    private final TestPartitionTransitionContext transitionContext = new TestPartitionTransitionContext();
    private BackupApiRequestHandlerStep step;

    BackupApiRequestHandlerStepTest() {
    }

    @BeforeEach
    void setup() {
        this.transitionContext.setLogStream(this.logStream);
        this.transitionContext.setGatewayBrokerTransport(this.serverTransport);
        this.transitionContext.setConcurrencyControl((ConcurrencyControl)new TestConcurrencyControl());
        this.transitionContext.setDiskSpaceUsageMonitor(this.diskSpaceUsageMonitor);
        this.transitionContext.setActorSchedulingService(this.actorSchedulingService);
        this.transitionContext.setBrokerCfg(this.brokerCfg);
        this.step = new BackupApiRequestHandlerStep();
    }

    @Test
    void shouldInstallBackupRequestHandler() {
        Mockito.when((Object)this.logStream.newLogStreamWriter()).thenReturn((Object)TestActorFuture.completedFuture((Object)this.logStreamWriter));
        Mockito.when((Object)this.actorSchedulingService.submitActor((Actor)ArgumentMatchers.any())).thenReturn((Object)TestActorFuture.completedFuture(null));
        this.transitionTo(RaftServer.Role.LEADER);
        Assertions.assertThat((Object)this.transitionContext.getBackupApiRequestHandler()).isNotNull();
    }

    @ParameterizedTest
    @EnumSource(value=RaftServer.Role.class, names={"FOLLOWER", "CANDIDATE", "INACTIVE"})
    void shouldCloseBackupRequestHandler(RaftServer.Role targetRole, @Mock BackupApiRequestHandler requestHandlerFromPrevRole) {
        Mockito.when((Object)requestHandlerFromPrevRole.closeAsync()).thenReturn((Object)TestActorFuture.completedFuture(null));
        this.transitionContext.setBackupApiRequestHandler(requestHandlerFromPrevRole);
        this.transitionTo(targetRole);
        Assertions.assertThat((Object)this.transitionContext.getBackupApiRequestHandler()).isNull();
        ((BackupApiRequestHandler)Mockito.verify((Object)requestHandlerFromPrevRole)).closeAsync();
    }

    private void transitionTo(RaftServer.Role role) {
        this.step.prepareTransition((PartitionTransitionContext)this.transitionContext, 1L, role).join();
        this.step.transitionTo((PartitionTransitionContext)this.transitionContext, 1L, role).join();
        this.transitionContext.setCurrentRole(role);
    }
}

