/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.cluster.MemberId;
import io.atomix.raft.RaftServer;
import io.atomix.raft.partition.RaftPartition;
import io.camunda.zeebe.backup.api.BackupManager;
import io.camunda.zeebe.backup.api.BackupStore;
import io.camunda.zeebe.backup.management.NoopBackupManager;
import io.camunda.zeebe.backup.processing.CheckpointRecordsProcessor;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ClusterCfg;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.TestPartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.impl.steps.BackupServiceTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.PartitionTransitionTestArgumentProviders;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.testing.TestConcurrencyControl;
import java.nio.file.Path;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class BackupServiceTransitionStepTest {
    private static final TestConcurrencyControl TEST_CONCURRENCY_CONTROL = new TestConcurrencyControl();
    TestPartitionTransitionContext transitionContext = new TestPartitionTransitionContext();
    @Mock
    BackupManager backupManagerPreviousRole;
    @Mock
    CheckpointRecordsProcessor recordsProcessorPreviousRole;
    @Mock
    ActorSchedulingService actorSchedulingService;
    @Mock
    BackupStore backupStore;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    BrokerCfg brokerCfg;
    @Mock
    ClusterCfg clusterCfg;
    @Mock
    RaftPartition raftPartition;
    BackupServiceTransitionStep step;

    BackupServiceTransitionStepTest() {
    }

    @BeforeEach
    void setup() {
        this.transitionContext.setConcurrencyControl((ConcurrencyControl)TEST_CONCURRENCY_CONTROL);
        this.transitionContext.setActorSchedulingService(this.actorSchedulingService);
        this.transitionContext.setBackupStore(this.backupStore);
        this.transitionContext.setBrokerCfg(this.brokerCfg);
        this.transitionContext.setRaftPartition(this.raftPartition);
        Mockito.lenient().when((Object)this.brokerCfg.getCluster().getPartitionsCount()).thenReturn((Object)3);
        Mockito.lenient().when((Object)this.raftPartition.members()).thenReturn(Set.of(MemberId.from((String)"1"), MemberId.from((String)"2")));
        Mockito.lenient().when((Object)this.raftPartition.dataDirectory()).thenReturn((Object)Path.of("/tmp/zeebe", new String[0]).toFile());
        Mockito.lenient().when((Object)this.actorSchedulingService.submitActor((Actor)ArgumentMatchers.any())).thenReturn((Object)TEST_CONCURRENCY_CONTROL.completedFuture(null));
        Mockito.lenient().when((Object)this.backupManagerPreviousRole.closeAsync()).thenReturn((Object)TEST_CONCURRENCY_CONTROL.completedFuture(null));
        this.step = new BackupServiceTransitionStep();
    }

    @ParameterizedTest
    @ArgumentsSource(value=PartitionTransitionTestArgumentProviders.TransitionsThatShouldCloseService.class)
    void shouldCloseExistingService(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.setUpCurrentRole(currentRole);
        this.step.prepareTransition((PartitionTransitionContext)this.transitionContext, 1L, targetRole).join();
        Assertions.assertThat((Object)this.transitionContext.getBackupManager()).isNull();
        ((BackupManager)Mockito.verify((Object)this.backupManagerPreviousRole)).closeAsync();
        Assertions.assertThat((Object)this.transitionContext.getCheckpointProcessor()).isNull();
    }

    @ParameterizedTest
    @ArgumentsSource(value=PartitionTransitionTestArgumentProviders.TransitionsThatShouldInstallService.class)
    void shouldReInstallService(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.setUpCurrentRole(currentRole);
        this.transitionTo(targetRole);
        ((ObjectAssert)Assertions.assertThat((Object)this.transitionContext.getBackupManager()).isNotNull()).isNotEqualTo((Object)this.backupManagerPreviousRole);
        ((ObjectAssert)Assertions.assertThat((Object)this.transitionContext.getCheckpointProcessor()).isNotNull()).isNotEqualTo((Object)this.recordsProcessorPreviousRole);
    }

    @ParameterizedTest
    @ArgumentsSource(value=PartitionTransitionTestArgumentProviders.TransitionsThatShouldDoNothing.class)
    void shouldNotReInstallService(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.setUpCurrentRole(currentRole);
        BackupManager existingBackupManager = this.transitionContext.getBackupManager();
        CheckpointRecordsProcessor existingRecordsProcessor = this.transitionContext.getCheckpointProcessor();
        this.transitionTo(targetRole);
        Assertions.assertThat((Object)this.transitionContext.getBackupManager()).isEqualTo((Object)existingBackupManager);
        Assertions.assertThat((Object)this.transitionContext.getCheckpointProcessor()).isEqualTo((Object)existingRecordsProcessor);
    }

    @Test
    void shouldInstallNoopBackupManagerWhenFollower() {
        this.setUpCurrentRole(RaftServer.Role.LEADER);
        this.transitionTo(RaftServer.Role.FOLLOWER);
        Assertions.assertThat((Object)this.transitionContext.getBackupManager()).isInstanceOf(NoopBackupManager.class);
        ((ObjectAssert)Assertions.assertThat((Object)this.transitionContext.getCheckpointProcessor()).isNotNull()).isNotEqualTo((Object)this.recordsProcessorPreviousRole);
    }

    @Test
    void shouldInstallNoopBackupManagerWhenNoBackupStore() {
        this.setUpCurrentRole(RaftServer.Role.FOLLOWER);
        this.transitionContext.setBackupStore(null);
        this.transitionTo(RaftServer.Role.LEADER);
        Assertions.assertThat((Object)this.transitionContext.getBackupManager()).isInstanceOf(NoopBackupManager.class);
        ((ObjectAssert)Assertions.assertThat((Object)this.transitionContext.getCheckpointProcessor()).isNotNull()).isNotEqualTo((Object)this.recordsProcessorPreviousRole);
    }

    private void transitionTo(RaftServer.Role role) {
        this.step.prepareTransition((PartitionTransitionContext)this.transitionContext, 1L, role).join();
        this.step.transitionTo((PartitionTransitionContext)this.transitionContext, 1L, role).join();
        this.transitionContext.setCurrentRole(role);
    }

    private void setUpCurrentRole(RaftServer.Role currentRole) {
        this.transitionContext.setCurrentRole(currentRole);
        if (currentRole != null && currentRole != RaftServer.Role.INACTIVE) {
            this.transitionContext.setBackupManager(this.backupManagerPreviousRole);
            this.transitionContext.setCheckpointProcessor(this.recordsProcessorPreviousRole);
        }
    }
}

