/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.backup.api.BackupStore;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.DataCfg;
import io.camunda.zeebe.broker.system.configuration.backup.BackupStoreCfg;
import io.camunda.zeebe.broker.system.configuration.backup.S3BackupStoreConfig;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.TestPartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.impl.steps.BackupStoreTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.PartitionTransitionTestArgumentProviders;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.testing.TestConcurrencyControl;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.FutureAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class BackupStoreTransitionStepTest {
    private static final TestConcurrencyControl TEST_CONCURRENCY_CONTROL = new TestConcurrencyControl();
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    BrokerCfg brokerCfg;
    @Mock
    DataCfg dataCfg;
    @Mock
    BackupStore backupStorePreviousRole;
    private final TestPartitionTransitionContext transitionContext = new TestPartitionTransitionContext();
    private BackupStoreTransitionStep step;

    BackupStoreTransitionStepTest() {
    }

    @BeforeEach
    void setup() {
        this.transitionContext.setConcurrencyControl((ConcurrencyControl)TEST_CONCURRENCY_CONTROL);
        this.transitionContext.setBrokerCfg(this.brokerCfg);
        this.step = new BackupStoreTransitionStep();
    }

    @ParameterizedTest
    @ArgumentsSource(value=PartitionTransitionTestArgumentProviders.TransitionsThatShouldCloseService.class)
    void shouldCloseExistingService(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.setUpCurrentRole(currentRole);
        this.step.prepareTransition((PartitionTransitionContext)this.transitionContext, 1L, targetRole).join();
        ((ObjectAssert)Assertions.assertThat((Object)this.transitionContext.getBackupStore()).describedAs("BackupStore must be removed from the context", new Object[0])).isNull();
        ((BackupStore)Mockito.verify((Object)this.backupStorePreviousRole)).closeAsync();
    }

    @ParameterizedTest
    @ArgumentsSource(value=PartitionTransitionTestArgumentProviders.TransitionsThatShouldInstallService.class)
    void shouldReInstallServiceWhenStoreTypeAvailable(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.setUpCurrentRole(currentRole);
        this.configureStore(BackupStoreCfg.BackupStoreType.S3);
        this.transitionTo(targetRole);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)this.transitionContext.getBackupStore()).describedAs("New BackupStore must be installed", new Object[0])).isNotNull()).isNotEqualTo((Object)this.backupStorePreviousRole);
    }

    @Test
    void shouldFailToInstallWhenS3ConfigurationsAreNotAvailable() {
        this.setUpCurrentRole(null);
        this.configureStore(BackupStoreCfg.BackupStoreType.S3, new S3BackupStoreConfig());
        RaftServer.Role targetRole = RaftServer.Role.LEADER;
        this.step.prepareTransition((PartitionTransitionContext)this.transitionContext, 1L, targetRole).join();
        ActorFuture transitionFuture = this.step.transitionTo((PartitionTransitionContext)this.transitionContext, 1L, targetRole);
        ((FutureAssert)Assertions.assertThat((Future)transitionFuture).describedAs("Expected to fail installation when s3 configuration is not complete.", new Object[0])).failsWithin(Duration.ofMillis(500L)).withThrowableOfType(ExecutionException.class);
    }

    @ParameterizedTest
    @ArgumentsSource(value=PartitionTransitionTestArgumentProviders.TransitionsThatShouldInstallService.class)
    void shouldNotInstallServiceWhenStoreTypeIsNone(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.setUpCurrentRole(currentRole);
        this.configureStore(BackupStoreCfg.BackupStoreType.NONE);
        this.transitionTo(targetRole);
        Assertions.assertThat((Object)this.transitionContext.getBackupStore()).isNull();
    }

    @ParameterizedTest
    @ArgumentsSource(value=PartitionTransitionTestArgumentProviders.TransitionsThatShouldDoNothing.class)
    void shouldNotReInstallService(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.setUpCurrentRole(currentRole);
        BackupStore existingBackupStore = this.transitionContext.getBackupStore();
        this.transitionTo(targetRole);
        ((ObjectAssert)Assertions.assertThat((Object)this.transitionContext.getBackupStore()).describedAs("Existing backup store must not be removed from the context.", new Object[0])).isEqualTo((Object)existingBackupStore);
    }

    private void configureStore(BackupStoreCfg.BackupStoreType type) {
        S3BackupStoreConfig s3Config = new S3BackupStoreConfig();
        s3Config.setBucketName("bucket");
        s3Config.setRegion("region");
        s3Config.setRegion("endpoint");
        s3Config.setAccessKey("user");
        s3Config.setSecretKey("password");
        this.configureStore(type, s3Config);
    }

    private void configureStore(BackupStoreCfg.BackupStoreType type, S3BackupStoreConfig s3Config) {
        BackupStoreCfg backupCfg = new BackupStoreCfg();
        backupCfg.setStore(type);
        backupCfg.setS3(s3Config);
        Mockito.when((Object)this.brokerCfg.getData()).thenReturn((Object)this.dataCfg);
        Mockito.when((Object)this.dataCfg.getBackup()).thenReturn((Object)backupCfg);
    }

    private void transitionTo(RaftServer.Role role) {
        this.step.prepareTransition((PartitionTransitionContext)this.transitionContext, 1L, role).join();
        this.step.transitionTo((PartitionTransitionContext)this.transitionContext, 1L, role).join();
        this.transitionContext.setCurrentRole(role);
    }

    private void setUpCurrentRole(RaftServer.Role currentRole) {
        this.transitionContext.setCurrentRole(currentRole);
        if (currentRole != null && currentRole != RaftServer.Role.INACTIVE) {
            this.transitionContext.setBackupStore(this.backupStorePreviousRole);
            Mockito.lenient().when((Object)this.backupStorePreviousRole.closeAsync()).thenReturn(CompletableFuture.completedFuture(null));
        }
    }
}

