/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.exporter.repo.ExporterRepository;
import io.camunda.zeebe.broker.exporter.stream.ExporterDirector;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.TestPartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.impl.steps.ExporterDirectorPartitionTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.PartitionTransitionTestArgumentProviders;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.SchedulingHints;
import io.camunda.zeebe.scheduler.testing.TestActorFuture;
import io.camunda.zeebe.util.health.HealthMonitor;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class ExporterDirectorPartitionTransitionStepTest {
    final TestPartitionTransitionContext transitionContext = new TestPartitionTransitionContext();
    final ActorSchedulingService actorSchedulingService = (ActorSchedulingService)Mockito.mock(ActorSchedulingService.class);
    final ExporterRepository exporterRepository = (ExporterRepository)Mockito.mock(ExporterRepository.class);
    final ExporterDirector exporterDirectorFromPrevRole = (ExporterDirector)Mockito.mock(ExporterDirector.class);
    private ExporterDirectorPartitionTransitionStep step;

    ExporterDirectorPartitionTransitionStepTest() {
    }

    @BeforeEach
    void setup() {
        this.transitionContext.setLogStream((LogStream)Mockito.mock(LogStream.class));
        this.transitionContext.setComponentHealthMonitor((HealthMonitor)Mockito.mock(HealthMonitor.class));
        Mockito.when((Object)this.exporterRepository.getExporters()).thenReturn(Map.of());
        this.transitionContext.setExporterRepository(this.exporterRepository);
        Mockito.when((Object)this.actorSchedulingService.submitActor((Actor)ArgumentMatchers.any(), (SchedulingHints)ArgumentMatchers.any())).thenReturn((Object)TestActorFuture.completedFuture(null));
        this.transitionContext.setActorSchedulingService(this.actorSchedulingService);
        Mockito.when((Object)this.exporterDirectorFromPrevRole.closeAsync()).thenReturn((Object)TestActorFuture.completedFuture(null));
        this.step = new ExporterDirectorPartitionTransitionStep();
    }

    @ParameterizedTest
    @ArgumentsSource(value=PartitionTransitionTestArgumentProviders.TransitionsThatShouldCloseService.class)
    void shouldCloseExistingStreamProcessor(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.initializeContext(currentRole);
        this.step.prepareTransition((PartitionTransitionContext)this.transitionContext, 1L, targetRole).join();
        Assertions.assertThat((Object)this.transitionContext.getExporterDirector()).isNull();
        ((ExporterDirector)Mockito.verify((Object)this.exporterDirectorFromPrevRole)).closeAsync();
    }

    @ParameterizedTest
    @ArgumentsSource(value=PartitionTransitionTestArgumentProviders.TransitionsThatShouldInstallService.class)
    void shouldInstallExporterDirector(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.initializeContext(currentRole);
        this.transitionTo(targetRole);
        ((ObjectAssert)Assertions.assertThat((Object)this.transitionContext.getExporterDirector()).isNotNull()).isNotEqualTo((Object)this.exporterDirectorFromPrevRole);
    }

    @ParameterizedTest
    @ArgumentsSource(value=PartitionTransitionTestArgumentProviders.TransitionsThatShouldDoNothing.class)
    void shouldNotInstallExporterDirector(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.initializeContext(currentRole);
        ExporterDirector existingExporterDirector = this.transitionContext.getExporterDirector();
        this.transitionTo(targetRole);
        Assertions.assertThat((Object)this.transitionContext.getExporterDirector()).isEqualTo((Object)existingExporterDirector);
        ((ExporterDirector)Mockito.verify((Object)this.exporterDirectorFromPrevRole, (VerificationMode)Mockito.never())).closeAsync();
    }

    @ParameterizedTest
    @EnumSource(value=RaftServer.Role.class, names={"FOLLOWER", "LEADER", "CANDIDATE"})
    void shouldCloseWhenTransitionToInactive(RaftServer.Role currentRole) {
        this.initializeContext(currentRole);
        this.transitionTo(RaftServer.Role.INACTIVE);
        Assertions.assertThat((Object)this.transitionContext.getExporterDirector()).isNull();
        ((ExporterDirector)Mockito.verify((Object)this.exporterDirectorFromPrevRole)).closeAsync();
    }

    private void initializeContext(RaftServer.Role currentRole) {
        this.transitionContext.setCurrentRole(currentRole);
        if (currentRole != null && currentRole != RaftServer.Role.INACTIVE) {
            this.transitionContext.setExporterDirector(this.exporterDirectorFromPrevRole);
        }
    }

    private void transitionTo(RaftServer.Role role) {
        this.step.prepareTransition((PartitionTransitionContext)this.transitionContext, 1L, role).join();
        this.step.transitionTo((PartitionTransitionContext)this.transitionContext, 1L, role).join();
        this.transitionContext.setCurrentRole(role);
    }
}

