/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftServer;
import io.atomix.raft.partition.RaftPartition;
import io.atomix.raft.partition.impl.RaftPartitionServer;
import io.atomix.raft.zeebe.ZeebeLogAppender;
import io.camunda.zeebe.broker.logstreams.AtomixLogStorage;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.TestPartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.impl.steps.LogStoragePartitionTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.PartitionTransitionTestArgumentProviders;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.util.health.HealthMonitor;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.Mockito;

class LogStoragePartitionTransitionStepTest {
    TestPartitionTransitionContext transitionContext = new TestPartitionTransitionContext();
    private LogStoragePartitionTransitionStep step;
    private final RaftPartition raftPartition = (RaftPartition)Mockito.mock(RaftPartition.class);
    private final RaftPartitionServer raftServer = (RaftPartitionServer)Mockito.mock(RaftPartitionServer.class);
    private final AtomixLogStorage logStorageFromPrevRole = (AtomixLogStorage)Mockito.mock(AtomixLogStorage.class);

    LogStoragePartitionTransitionStepTest() {
    }

    @BeforeEach
    void setup() {
        this.transitionContext.setLogStream((LogStream)Mockito.mock(LogStream.class));
        this.transitionContext.setComponentHealthMonitor((HealthMonitor)Mockito.mock(HealthMonitor.class));
        Mockito.when((Object)this.raftPartition.getServer()).thenReturn((Object)this.raftServer);
        Mockito.when((Object)this.raftServer.getTerm()).thenReturn((Object)1L);
        Mockito.when((Object)this.raftServer.getAppender()).thenReturn(Optional.of((ZeebeLogAppender)Mockito.mock(ZeebeLogAppender.class)));
        this.transitionContext.setRaftPartition(this.raftPartition);
        this.step = new LogStoragePartitionTransitionStep();
    }

    @ParameterizedTest
    @EnumSource(value=RaftServer.Role.class, names={"INACTIVE", "FOLLOWER", "CANDIDATE"})
    void shouldThrowRecoverableExceptionOnTermMismatch(RaftServer.Role currentRole) {
        this.initializeContext(currentRole);
        this.step.prepareTransition((PartitionTransitionContext)this.transitionContext, 1L, RaftServer.Role.LEADER);
        Mockito.when((Object)this.raftServer.getTerm()).thenReturn((Object)2L);
        Assertions.assertThatThrownBy(() -> this.step.transitionTo((PartitionTransitionContext)this.transitionContext, 1L, RaftServer.Role.LEADER).join()).hasCauseInstanceOf(LogStoragePartitionTransitionStep.NotLeaderException.class);
    }

    @ParameterizedTest
    @EnumSource(value=RaftServer.Role.class, names={"INACTIVE", "FOLLOWER", "CANDIDATE"})
    void shouldThrowRecoverableExceptionWhenNoAppender(RaftServer.Role currentRole) {
        this.initializeContext(currentRole);
        this.step.prepareTransition((PartitionTransitionContext)this.transitionContext, 1L, RaftServer.Role.LEADER);
        Mockito.when((Object)this.raftServer.getAppender()).thenReturn(Optional.empty());
        Assertions.assertThatThrownBy(() -> this.step.transitionTo((PartitionTransitionContext)this.transitionContext, 1L, RaftServer.Role.LEADER).join()).hasCauseInstanceOf(LogStoragePartitionTransitionStep.NotLeaderException.class);
    }

    @ParameterizedTest
    @ArgumentsSource(value=PartitionTransitionTestArgumentProviders.TransitionsThatShouldCloseService.class)
    void shouldCloseExistingLogStorage(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.initializeContext(currentRole);
        this.step.prepareTransition((PartitionTransitionContext)this.transitionContext, 1L, targetRole).join();
        Assertions.assertThat((Object)this.transitionContext.getLogStorage()).isNull();
    }

    @ParameterizedTest
    @ArgumentsSource(value=PartitionTransitionTestArgumentProviders.TransitionsThatShouldInstallService.class)
    void shouldInstallLogStorage(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.initializeContext(currentRole);
        AtomixLogStorage existingLogStorage = this.transitionContext.getLogStorage();
        this.transitionTo(targetRole);
        ((ObjectAssert)Assertions.assertThat((Object)this.transitionContext.getLogStorage()).isNotNull()).isNotEqualTo((Object)existingLogStorage);
    }

    @ParameterizedTest
    @ArgumentsSource(value=PartitionTransitionTestArgumentProviders.TransitionsThatShouldDoNothing.class)
    void shouldNotReInstallLogStorage(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.initializeContext(currentRole);
        AtomixLogStorage existingLogStorage = this.transitionContext.getLogStorage();
        this.transitionTo(targetRole);
        Assertions.assertThat((Object)this.transitionContext.getLogStorage()).isEqualTo((Object)existingLogStorage);
    }

    @ParameterizedTest
    @EnumSource(value=RaftServer.Role.class, names={"FOLLOWER", "LEADER", "CANDIDATE"})
    void shouldCloseWhenTransitioningToInactive(RaftServer.Role currentRole) {
        this.initializeContext(currentRole);
        this.transitionTo(RaftServer.Role.INACTIVE);
        Assertions.assertThat((Object)this.transitionContext.getLogStorage()).isNull();
    }

    private void initializeContext(RaftServer.Role currentRole) {
        this.transitionContext.setCurrentRole(currentRole);
        if (currentRole != null && currentRole != RaftServer.Role.INACTIVE) {
            this.transitionContext.setLogStorage(this.logStorageFromPrevRole);
        }
    }

    private void transitionTo(RaftServer.Role role) {
        this.step.prepareTransition((PartitionTransitionContext)this.transitionContext, 1L, role).join();
        this.step.transitionTo((PartitionTransitionContext)this.transitionContext, 1L, role).join();
        this.transitionContext.setCurrentRole(role);
    }
}

