/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftServer;
import io.atomix.raft.partition.RaftPartition;
import io.atomix.raft.partition.impl.RaftPartitionServer;
import io.camunda.zeebe.broker.logstreams.AtomixLogStorage;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.TestPartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.impl.steps.LogStreamPartitionTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.PartitionTransitionTestArgumentProviders;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamBuilder;
import io.camunda.zeebe.scheduler.testing.TestActorFuture;
import io.camunda.zeebe.util.health.HealthMonitor;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class LogStreamPartitionTransitionStepTest {
    final TestPartitionTransitionContext transitionContext = new TestPartitionTransitionContext();
    private LogStreamPartitionTransitionStep step;
    private final RaftPartition raftPartition = (RaftPartition)Mockito.mock(RaftPartition.class);
    private final RaftPartitionServer raftServer = (RaftPartitionServer)Mockito.mock(RaftPartitionServer.class);
    private final LogStream logStream = (LogStream)Mockito.mock(LogStream.class);
    private final LogStreamBuilder logStreamBuilder = (LogStreamBuilder)Mockito.spy((Object)LogStream.builder());
    private final LogStream logStreamFromPrevRole = (LogStream)Mockito.mock(LogStream.class);

    LogStreamPartitionTransitionStepTest() {
    }

    @BeforeEach
    void setup() {
        this.transitionContext.setComponentHealthMonitor((HealthMonitor)Mockito.mock(HealthMonitor.class));
        this.transitionContext.setLogStorage((AtomixLogStorage)Mockito.mock(AtomixLogStorage.class));
        Mockito.when((Object)this.raftPartition.getServer()).thenReturn((Object)this.raftServer);
        this.transitionContext.setRaftPartition(this.raftPartition);
        ((LogStreamBuilder)Mockito.doReturn((Object)TestActorFuture.completedFuture((Object)this.logStream)).when((Object)this.logStreamBuilder)).buildAsync();
        Mockito.when((Object)this.logStream.closeAsync()).thenReturn((Object)TestActorFuture.completedFuture(null));
        Mockito.when((Object)this.logStreamFromPrevRole.closeAsync()).thenReturn((Object)TestActorFuture.completedFuture(null));
        this.step = new LogStreamPartitionTransitionStep(() -> this.logStreamBuilder);
    }

    @ParameterizedTest
    @ArgumentsSource(value=PartitionTransitionTestArgumentProviders.TransitionsThatShouldCloseService.class)
    void shouldCloseExistingLogStream(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.initializeContext(currentRole);
        this.step.prepareTransition((PartitionTransitionContext)this.transitionContext, 1L, targetRole).join();
        Assertions.assertThat((Object)this.transitionContext.getLogStream()).isNull();
        ((LogStream)Mockito.verify((Object)this.logStreamFromPrevRole)).closeAsync();
    }

    @ParameterizedTest
    @ArgumentsSource(value=PartitionTransitionTestArgumentProviders.TransitionsThatShouldInstallService.class)
    void shouldInstallLogStream(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.initializeContext(currentRole);
        LogStream existingLogStream = this.transitionContext.getLogStream();
        this.transitionTo(targetRole);
        ((ObjectAssert)Assertions.assertThat((Object)this.transitionContext.getLogStream()).isNotNull()).isNotEqualTo((Object)existingLogStream);
        ((LogStreamBuilder)Mockito.verify((Object)this.logStreamBuilder)).buildAsync();
    }

    @ParameterizedTest
    @ArgumentsSource(value=PartitionTransitionTestArgumentProviders.TransitionsThatShouldDoNothing.class)
    void shoulNotReInstallLogStorage(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.initializeContext(currentRole);
        LogStream existingLogStream = this.transitionContext.getLogStream();
        this.transitionTo(targetRole);
        Assertions.assertThat((Object)this.transitionContext.getLogStream()).isEqualTo((Object)existingLogStream);
        ((LogStreamBuilder)Mockito.verify((Object)this.logStreamBuilder, (VerificationMode)Mockito.never())).buildAsync();
    }

    @ParameterizedTest
    @EnumSource(value=RaftServer.Role.class, names={"FOLLOWER", "LEADER", "CANDIDATE"})
    void shouldCloseWhenTransitioningToInactive(RaftServer.Role currentRole) {
        this.initializeContext(currentRole);
        this.transitionTo(RaftServer.Role.INACTIVE);
        Assertions.assertThat((Object)this.transitionContext.getStreamProcessor()).isNull();
        ((LogStream)Mockito.verify((Object)this.logStreamFromPrevRole)).closeAsync();
        ((LogStreamBuilder)Mockito.verify((Object)this.logStreamBuilder, (VerificationMode)Mockito.never())).buildAsync();
    }

    private void initializeContext(RaftServer.Role currentRole) {
        this.transitionContext.setCurrentRole(currentRole);
        if (currentRole != null && currentRole != RaftServer.Role.INACTIVE) {
            this.transitionContext.setLogStream(this.logStreamFromPrevRole);
        }
    }

    private void transitionTo(RaftServer.Role role) {
        this.step.prepareTransition((PartitionTransitionContext)this.transitionContext, 1L, role).join();
        this.step.transitionTo((PartitionTransitionContext)this.transitionContext, 1L, role).join();
        this.transitionContext.setCurrentRole(role);
    }
}

