/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.TestPartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.impl.steps.QueryServicePartitionTransitionStep;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.state.QueryService;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

class QueryServicePartitionTransitionStepTest {
    TestPartitionTransitionContext transitionContext = new TestPartitionTransitionContext();
    private final ZeebeDb zeebeDb = (ZeebeDb)Mockito.mock(ZeebeDb.class);
    private final QueryService queryServiceFromPrevRole = (QueryService)Mockito.mock(QueryService.class);
    private QueryServicePartitionTransitionStep step;

    QueryServicePartitionTransitionStepTest() {
    }

    @BeforeEach
    void setup() {
        this.transitionContext.setZeebeDb(this.zeebeDb);
        this.step = new QueryServicePartitionTransitionStep();
    }

    @ParameterizedTest
    @MethodSource(value={"provideTransitionsThatShouldDoNothing"})
    void shouldNotInstallQueryService(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.initializeContext(currentRole);
        QueryService existingQueryService = this.transitionContext.getQueryService();
        this.transitionTo(targetRole);
        Assertions.assertThat((Object)this.transitionContext.getQueryService()).isEqualTo((Object)existingQueryService);
    }

    @ParameterizedTest
    @MethodSource(value={"provideTransitionsThatShouldCloseExistingQueryService"})
    void shouldCloseExistingQueryService(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.initializeContext(currentRole);
        this.step.prepareTransition((PartitionTransitionContext)this.transitionContext, 1L, targetRole);
        Assertions.assertThat((Object)this.transitionContext.getQueryService()).isNull();
    }

    @ParameterizedTest
    @MethodSource(value={"provideTransitionsThatShouldInstallQueryService"})
    void shouldInstallQueryService(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.initializeContext(currentRole);
        QueryService existingQueryService = this.transitionContext.getQueryService();
        this.transitionTo(targetRole);
        ((ObjectAssert)Assertions.assertThat((Object)this.transitionContext.getQueryService()).isNotNull()).isNotEqualTo((Object)existingQueryService);
    }

    @ParameterizedTest
    @EnumSource(value=RaftServer.Role.class, names={"FOLLOWER", "LEADER", "CANDIDATE"})
    void shouldCloseWhenTransitioningToInactive(RaftServer.Role currentRole) {
        this.initializeContext(currentRole);
        this.transitionTo(RaftServer.Role.INACTIVE);
        Assertions.assertThat((Object)this.transitionContext.getQueryService()).isNull();
    }

    private static Stream<Arguments> provideTransitionsThatShouldDoNothing() {
        return Stream.of(Arguments.of((Object[])new Object[]{RaftServer.Role.CANDIDATE, RaftServer.Role.FOLLOWER}), Arguments.of((Object[])new Object[]{RaftServer.Role.FOLLOWER, RaftServer.Role.CANDIDATE}), Arguments.of((Object[])new Object[]{RaftServer.Role.CANDIDATE, RaftServer.Role.LEADER}), Arguments.of((Object[])new Object[]{RaftServer.Role.FOLLOWER, RaftServer.Role.LEADER}), Arguments.of((Object[])new Object[]{null, RaftServer.Role.INACTIVE}));
    }

    private static Stream<Arguments> provideTransitionsThatShouldInstallQueryService() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, RaftServer.Role.FOLLOWER}), Arguments.of((Object[])new Object[]{null, RaftServer.Role.LEADER}), Arguments.of((Object[])new Object[]{null, RaftServer.Role.CANDIDATE}), Arguments.of((Object[])new Object[]{RaftServer.Role.LEADER, RaftServer.Role.FOLLOWER}), Arguments.of((Object[])new Object[]{RaftServer.Role.LEADER, RaftServer.Role.CANDIDATE}), Arguments.of((Object[])new Object[]{RaftServer.Role.INACTIVE, RaftServer.Role.FOLLOWER}), Arguments.of((Object[])new Object[]{RaftServer.Role.INACTIVE, RaftServer.Role.LEADER}), Arguments.of((Object[])new Object[]{RaftServer.Role.INACTIVE, RaftServer.Role.CANDIDATE}));
    }

    private static Stream<Arguments> provideTransitionsThatShouldCloseExistingQueryService() {
        return Stream.of(Arguments.of((Object[])new Object[]{RaftServer.Role.LEADER, RaftServer.Role.FOLLOWER}), Arguments.of((Object[])new Object[]{RaftServer.Role.LEADER, RaftServer.Role.CANDIDATE}), Arguments.of((Object[])new Object[]{RaftServer.Role.LEADER, RaftServer.Role.INACTIVE}), Arguments.of((Object[])new Object[]{RaftServer.Role.FOLLOWER, RaftServer.Role.INACTIVE}), Arguments.of((Object[])new Object[]{RaftServer.Role.CANDIDATE, RaftServer.Role.INACTIVE}));
    }

    private void initializeContext(RaftServer.Role currentRole) {
        this.transitionContext.setCurrentRole(currentRole);
        if (currentRole != null && currentRole != RaftServer.Role.INACTIVE) {
            this.transitionContext.setQueryService(this.queryServiceFromPrevRole);
        }
    }

    private void transitionTo(RaftServer.Role role) {
        this.step.prepareTransition((PartitionTransitionContext)this.transitionContext, 1L, role).join();
        this.step.transitionTo((PartitionTransitionContext)this.transitionContext, 1L, role).join();
        this.transitionContext.setCurrentRole(role);
    }
}

