/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftServer;
import io.atomix.raft.partition.RaftPartition;
import io.atomix.raft.partition.impl.RaftPartitionServer;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.TestPartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.impl.AsyncSnapshotDirector;
import io.camunda.zeebe.broker.system.partitions.impl.steps.PartitionTransitionTestArgumentProviders;
import io.camunda.zeebe.broker.system.partitions.impl.steps.SnapshotDirectorPartitionTransitionStep;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.SchedulingHints;
import io.camunda.zeebe.scheduler.testing.TestActorFuture;
import io.camunda.zeebe.stream.impl.StreamProcessor;
import io.camunda.zeebe.util.health.HealthMonitor;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class SnapshotDirectorPartitionTransitionStepTest {
    TestPartitionTransitionContext transitionContext = new TestPartitionTransitionContext();
    private SnapshotDirectorPartitionTransitionStep step;
    private final RaftPartition raftPartition = (RaftPartition)Mockito.mock(RaftPartition.class);
    private final RaftPartitionServer raftServer = (RaftPartitionServer)Mockito.mock(RaftPartitionServer.class);
    private final ActorSchedulingService actorSchedulingService = (ActorSchedulingService)Mockito.mock(ActorSchedulingService.class);
    private final AsyncSnapshotDirector snapshotDirectorFromPrevRole = (AsyncSnapshotDirector)Mockito.mock(AsyncSnapshotDirector.class);

    SnapshotDirectorPartitionTransitionStepTest() {
    }

    @BeforeEach
    void setup() {
        this.transitionContext.setComponentHealthMonitor((HealthMonitor)Mockito.mock(HealthMonitor.class));
        this.transitionContext.setStreamProcessor((StreamProcessor)Mockito.mock(StreamProcessor.class));
        this.transitionContext.setBrokerCfg(new BrokerCfg());
        Mockito.when((Object)this.raftPartition.getServer()).thenReturn((Object)this.raftServer);
        this.transitionContext.setRaftPartition(this.raftPartition);
        Mockito.when((Object)this.actorSchedulingService.submitActor((Actor)ArgumentMatchers.any(), (SchedulingHints)ArgumentMatchers.any())).thenReturn((Object)TestActorFuture.completedFuture(null));
        this.transitionContext.setActorSchedulingService(this.actorSchedulingService);
        Mockito.when((Object)this.snapshotDirectorFromPrevRole.closeAsync()).thenReturn((Object)TestActorFuture.completedFuture(null));
        this.step = new SnapshotDirectorPartitionTransitionStep();
    }

    @ParameterizedTest
    @ArgumentsSource(value=PartitionTransitionTestArgumentProviders.TransitionsThatShouldCloseService.class)
    void shouldCloseExistingSnapshotDirector(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.initializeContext(currentRole);
        this.step.prepareTransition((PartitionTransitionContext)this.transitionContext, 1L, targetRole).join();
        Assertions.assertThat((Object)this.transitionContext.getSnapshotDirector()).isNull();
        ((AsyncSnapshotDirector)Mockito.verify((Object)this.snapshotDirectorFromPrevRole)).closeAsync();
    }

    @ParameterizedTest
    @ArgumentsSource(value=PartitionTransitionTestArgumentProviders.TransitionsThatShouldInstallService.class)
    void shouldReInstallSnapshotDirector(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.initializeContext(currentRole);
        AsyncSnapshotDirector existingSnapshotDirector = this.transitionContext.getSnapshotDirector();
        this.transitionTo(targetRole);
        ((ObjectAssert)Assertions.assertThat((Object)this.transitionContext.getSnapshotDirector()).isNotNull()).isNotEqualTo((Object)existingSnapshotDirector);
    }

    @ParameterizedTest
    @ArgumentsSource(value=PartitionTransitionTestArgumentProviders.TransitionsThatShouldDoNothing.class)
    void shouldNotReInstallSnapshotDirector(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.initializeContext(currentRole);
        AsyncSnapshotDirector existingSnapshotDirector = this.transitionContext.getSnapshotDirector();
        this.transitionTo(targetRole);
        Assertions.assertThat((Object)this.transitionContext.getSnapshotDirector()).isEqualTo((Object)existingSnapshotDirector);
    }

    @ParameterizedTest
    @EnumSource(value=RaftServer.Role.class, names={"FOLLOWER", "LEADER", "CANDIDATE"})
    void shouldCloseWhenTransitioningToInactive(RaftServer.Role currentRole) {
        this.initializeContext(currentRole);
        this.transitionTo(RaftServer.Role.INACTIVE);
        Assertions.assertThat((Object)this.transitionContext.getSnapshotDirector()).isNull();
    }

    private void initializeContext(RaftServer.Role currentRole) {
        this.transitionContext.setCurrentRole(currentRole);
        if (currentRole != null && currentRole != RaftServer.Role.INACTIVE) {
            this.transitionContext.setSnapshotDirector(this.snapshotDirectorFromPrevRole);
        }
    }

    private void transitionTo(RaftServer.Role role) {
        this.step.prepareTransition((PartitionTransitionContext)this.transitionContext, 1L, role).join();
        this.step.transitionTo((PartitionTransitionContext)this.transitionContext, 1L, role).join();
        this.transitionContext.setCurrentRole(role);
    }
}

