/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.TestPartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.impl.steps.PartitionTransitionTestArgumentProviders;
import io.camunda.zeebe.broker.system.partitions.impl.steps.StreamProcessorTransitionStep;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.testing.TestActorFuture;
import io.camunda.zeebe.scheduler.testing.TestConcurrencyControl;
import io.camunda.zeebe.stream.impl.StreamProcessor;
import io.camunda.zeebe.stream.impl.StreamProcessorBuilder;
import io.camunda.zeebe.util.health.HealthMonitor;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class StreamProcessorTransitionStepTest {
    private static final TestConcurrencyControl TEST_CONCURRENCY_CONTROL = new TestConcurrencyControl();
    TestPartitionTransitionContext transitionContext = new TestPartitionTransitionContext();
    final StreamProcessorBuilder streamProcessorBuilder = (StreamProcessorBuilder)Mockito.spy(StreamProcessorBuilder.class);
    final StreamProcessor streamProcessor = (StreamProcessor)Mockito.mock(StreamProcessor.class);
    final StreamProcessor streamProcessorFromPrevRole = (StreamProcessor)Mockito.mock(StreamProcessor.class);
    private StreamProcessorTransitionStep step;

    StreamProcessorTransitionStepTest() {
    }

    @BeforeEach
    void setup() {
        this.transitionContext.setLogStream((LogStream)Mockito.mock(LogStream.class));
        this.transitionContext.setComponentHealthMonitor((HealthMonitor)Mockito.mock(HealthMonitor.class));
        this.transitionContext.setConcurrencyControl((ConcurrencyControl)TEST_CONCURRENCY_CONTROL);
        ((StreamProcessorBuilder)Mockito.doReturn((Object)this.streamProcessor).when((Object)this.streamProcessorBuilder)).build();
        Mockito.when((Object)this.streamProcessor.openAsync(ArgumentMatchers.anyBoolean())).thenReturn((Object)TestActorFuture.completedFuture(null));
        Mockito.when((Object)this.streamProcessor.closeAsync()).thenReturn((Object)TestActorFuture.completedFuture(null));
        Mockito.when((Object)this.streamProcessorFromPrevRole.closeAsync()).thenReturn((Object)TestActorFuture.completedFuture(null));
        this.step = new StreamProcessorTransitionStep((ctx, role) -> this.streamProcessor);
    }

    @ParameterizedTest
    @ArgumentsSource(value=PartitionTransitionTestArgumentProviders.TransitionsThatShouldCloseService.class)
    void shouldCloseExistingStreamProcessor(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.transitionContext.setCurrentRole(currentRole);
        if (currentRole != null && currentRole != RaftServer.Role.INACTIVE) {
            this.transitionContext.setStreamProcessor(this.streamProcessorFromPrevRole);
        }
        this.step.prepareTransition((PartitionTransitionContext)this.transitionContext, 1L, targetRole).join();
        Assertions.assertThat((Object)this.transitionContext.getStreamProcessor()).isNull();
        ((StreamProcessor)Mockito.verify((Object)this.streamProcessorFromPrevRole)).closeAsync();
    }

    @ParameterizedTest
    @ArgumentsSource(value=PartitionTransitionTestArgumentProviders.TransitionsThatShouldInstallService.class)
    void shouldReInstallStreamProcessor(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.transitionContext.setCurrentRole(currentRole);
        if (currentRole != null && currentRole != RaftServer.Role.INACTIVE) {
            this.transitionContext.setStreamProcessor(this.streamProcessorFromPrevRole);
        }
        this.transitionTo(targetRole);
        ((ObjectAssert)Assertions.assertThat((Object)this.transitionContext.getStreamProcessor()).isNotNull()).isNotEqualTo((Object)this.streamProcessorFromPrevRole);
        ((StreamProcessor)Mockito.verify((Object)this.streamProcessor)).openAsync(ArgumentMatchers.anyBoolean());
    }

    @ParameterizedTest
    @ArgumentsSource(value=PartitionTransitionTestArgumentProviders.TransitionsThatShouldDoNothing.class)
    void shouldNotCloseExistingStreamProcessor(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.transitionContext.setCurrentRole(currentRole);
        if (currentRole != null && currentRole != RaftServer.Role.INACTIVE) {
            this.transitionContext.setStreamProcessor(this.streamProcessorFromPrevRole);
        }
        StreamProcessor existingStreamProcessor = this.transitionContext.getStreamProcessor();
        this.step.prepareTransition((PartitionTransitionContext)this.transitionContext, 1L, targetRole).join();
        Assertions.assertThat((Object)this.transitionContext.getStreamProcessor()).isEqualTo((Object)existingStreamProcessor);
        ((StreamProcessor)Mockito.verify((Object)this.streamProcessorFromPrevRole, (VerificationMode)Mockito.never())).closeAsync();
    }

    @ParameterizedTest
    @ArgumentsSource(value=PartitionTransitionTestArgumentProviders.TransitionsThatShouldDoNothing.class)
    void shouldNotReInstallStreamProcessor(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.transitionContext.setCurrentRole(currentRole);
        if (currentRole != null && currentRole != RaftServer.Role.INACTIVE) {
            this.transitionContext.setStreamProcessor(this.streamProcessorFromPrevRole);
        }
        StreamProcessor existingStreamProcessor = this.transitionContext.getStreamProcessor();
        this.transitionTo(targetRole);
        Assertions.assertThat((Object)this.transitionContext.getStreamProcessor()).isEqualTo((Object)existingStreamProcessor);
    }

    @ParameterizedTest
    @EnumSource(value=RaftServer.Role.class, names={"FOLLOWER", "LEADER", "CANDIDATE"})
    void shouldCloseStreamProcessorWhenTransitioningToInactive(RaftServer.Role currentRole) {
        this.transitionContext.setCurrentRole(currentRole);
        this.transitionContext.setStreamProcessor(this.streamProcessorFromPrevRole);
        this.transitionTo(RaftServer.Role.INACTIVE);
        Assertions.assertThat((Object)this.transitionContext.getStreamProcessor()).isNull();
        ((StreamProcessor)Mockito.verify((Object)this.streamProcessorFromPrevRole)).closeAsync();
    }

    private void transitionTo(RaftServer.Role role) {
        this.step.prepareTransition((PartitionTransitionContext)this.transitionContext, 1L, role).join();
        this.step.transitionTo((PartitionTransitionContext)this.transitionContext, 1L, role).join();
        this.transitionContext.setCurrentRole(role);
    }
}

