/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.StateController;
import io.camunda.zeebe.broker.system.partitions.TestPartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.impl.steps.ZeebeDbPartitionTransitionStep;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.scheduler.testing.TestActorFuture;
import java.io.IOException;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class ZeebeDbPartitionTransitionStepTest {
    TestPartitionTransitionContext transitionContext = new TestPartitionTransitionContext();
    private final StateController stateController = (StateController)Mockito.mock(StateController.class);
    private final ZeebeDb zeebeDb = (ZeebeDb)Mockito.mock(ZeebeDb.class);
    private final ZeebeDb zeebeDbFromPrevRole = (ZeebeDb)Mockito.mock(ZeebeDb.class);
    private ZeebeDbPartitionTransitionStep step;

    ZeebeDbPartitionTransitionStepTest() {
    }

    @BeforeEach
    void setup() throws IOException {
        Mockito.when((Object)this.stateController.recover()).thenReturn((Object)TestActorFuture.completedFuture((Object)this.zeebeDb));
        this.transitionContext.setStateController(this.stateController);
        this.step = new ZeebeDbPartitionTransitionStep();
    }

    @ParameterizedTest
    @MethodSource(value={"provideTransitionsThatShouldDoNothing"})
    void shouldNotCloseZeebeDb(RaftServer.Role currentRole, RaftServer.Role targetRole) throws Exception {
        this.transitionContext.setCurrentRole(currentRole);
        if (currentRole != null && currentRole != RaftServer.Role.INACTIVE) {
            this.transitionContext.setZeebeDb(this.zeebeDbFromPrevRole);
        }
        ZeebeDb existingZeebeDb = this.transitionContext.getZeebeDb();
        this.step.prepareTransition((PartitionTransitionContext)this.transitionContext, 1L, targetRole);
        Assertions.assertThat((Object)this.transitionContext.getZeebeDb()).isEqualTo((Object)existingZeebeDb);
        ((StateController)Mockito.verify((Object)this.stateController, (VerificationMode)Mockito.never())).closeDb();
    }

    @ParameterizedTest
    @MethodSource(value={"provideTransitionsThatShouldDoNothing"})
    void shouldNotReInstallZeebeDb(RaftServer.Role currentRole, RaftServer.Role targetRole) throws Exception {
        this.transitionContext.setCurrentRole(currentRole);
        if (currentRole != null && currentRole != RaftServer.Role.INACTIVE) {
            this.transitionContext.setZeebeDb(this.zeebeDbFromPrevRole);
        }
        ZeebeDb existingZeebeDb = this.transitionContext.getZeebeDb();
        this.transitionTo(targetRole);
        Assertions.assertThat((Object)this.transitionContext.getZeebeDb()).isEqualTo((Object)existingZeebeDb);
        ((StateController)Mockito.verify((Object)this.stateController, (VerificationMode)Mockito.never())).closeDb();
    }

    @ParameterizedTest
    @MethodSource(value={"provideTransitionsThatShouldCloseExistingZeebeDb"})
    void shouldCloseExistingZeebeDb(RaftServer.Role currentRole, RaftServer.Role targetRole) throws Exception {
        this.transitionContext.setCurrentRole(currentRole);
        if (currentRole != null && currentRole != RaftServer.Role.INACTIVE) {
            this.transitionContext.setZeebeDb(this.zeebeDbFromPrevRole);
        }
        this.step.prepareTransition((PartitionTransitionContext)this.transitionContext, 1L, targetRole);
        Assertions.assertThat((Object)this.transitionContext.getZeebeDb()).isNull();
        ((StateController)Mockito.verify((Object)this.stateController)).closeDb();
    }

    @ParameterizedTest
    @MethodSource(value={"provideTransitionsThatShouldInstallZeebeDb"})
    void shouldInstallZeebeDb(RaftServer.Role currentRole, RaftServer.Role targetRole) {
        this.transitionContext.setCurrentRole(currentRole);
        if (currentRole != null && currentRole != RaftServer.Role.INACTIVE) {
            this.transitionContext.setZeebeDb(this.zeebeDbFromPrevRole);
        }
        ZeebeDb existingZeebeDb = this.transitionContext.getZeebeDb();
        this.transitionTo(targetRole);
        Assertions.assertThat((Object)this.transitionContext.getZeebeDb()).isNotEqualTo((Object)existingZeebeDb);
        ((StateController)Mockito.verify((Object)this.stateController)).recover();
    }

    @ParameterizedTest
    @EnumSource(value=RaftServer.Role.class, names={"FOLLOWER", "LEADER", "CANDIDATE"})
    void shouldCloseZeebeDBWhenTransitioningToInactive(RaftServer.Role currentRole) throws Exception {
        this.transitionContext.setCurrentRole(currentRole);
        this.transitionContext.setZeebeDb(this.zeebeDbFromPrevRole);
        this.transitionTo(RaftServer.Role.INACTIVE);
        Assertions.assertThat((Object)this.transitionContext.getZeebeDb()).isNull();
        ((StateController)Mockito.verify((Object)this.stateController)).closeDb();
        ((StateController)Mockito.verify((Object)this.stateController, (VerificationMode)Mockito.never())).recover();
    }

    private static Stream<Arguments> provideTransitionsThatShouldDoNothing() {
        return Stream.of(Arguments.of((Object[])new Object[]{RaftServer.Role.CANDIDATE, RaftServer.Role.FOLLOWER}), Arguments.of((Object[])new Object[]{RaftServer.Role.FOLLOWER, RaftServer.Role.CANDIDATE}), Arguments.of((Object[])new Object[]{RaftServer.Role.CANDIDATE, RaftServer.Role.LEADER}), Arguments.of((Object[])new Object[]{RaftServer.Role.FOLLOWER, RaftServer.Role.LEADER}), Arguments.of((Object[])new Object[]{null, RaftServer.Role.INACTIVE}));
    }

    private static Stream<Arguments> provideTransitionsThatShouldInstallZeebeDb() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, RaftServer.Role.FOLLOWER}), Arguments.of((Object[])new Object[]{null, RaftServer.Role.LEADER}), Arguments.of((Object[])new Object[]{null, RaftServer.Role.CANDIDATE}), Arguments.of((Object[])new Object[]{RaftServer.Role.LEADER, RaftServer.Role.FOLLOWER}), Arguments.of((Object[])new Object[]{RaftServer.Role.LEADER, RaftServer.Role.CANDIDATE}), Arguments.of((Object[])new Object[]{RaftServer.Role.INACTIVE, RaftServer.Role.FOLLOWER}), Arguments.of((Object[])new Object[]{RaftServer.Role.INACTIVE, RaftServer.Role.LEADER}), Arguments.of((Object[])new Object[]{RaftServer.Role.INACTIVE, RaftServer.Role.CANDIDATE}));
    }

    private static Stream<Arguments> provideTransitionsThatShouldCloseExistingZeebeDb() {
        return Stream.of(Arguments.of((Object[])new Object[]{RaftServer.Role.LEADER, RaftServer.Role.FOLLOWER}), Arguments.of((Object[])new Object[]{RaftServer.Role.LEADER, RaftServer.Role.CANDIDATE}), Arguments.of((Object[])new Object[]{RaftServer.Role.LEADER, RaftServer.Role.INACTIVE}), Arguments.of((Object[])new Object[]{RaftServer.Role.FOLLOWER, RaftServer.Role.INACTIVE}), Arguments.of((Object[])new Object[]{RaftServer.Role.CANDIDATE, RaftServer.Role.INACTIVE}));
    }

    private void transitionTo(RaftServer.Role role) {
        this.step.prepareTransition((PartitionTransitionContext)this.transitionContext, 1L, role).join();
        this.step.transitionTo((PartitionTransitionContext)this.transitionContext, 1L, role).join();
        this.transitionContext.setCurrentRole(role);
    }
}

