/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.test;

import io.camunda.zeebe.broker.exporter.debug.DebugLogExporter;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ClusterCfg;
import io.camunda.zeebe.broker.system.configuration.ExporterCfg;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.time.Duration;
import java.util.Arrays;
import java.util.function.Consumer;

public final class EmbeddedBrokerConfigurator {
    public static final Consumer<BrokerCfg> DEBUG_EXPORTER = cfg -> cfg.getExporters().put(DebugLogExporter.defaultExporterId(), DebugLogExporter.defaultConfig());
    public static final Consumer<BrokerCfg> TEST_RECORDER = cfg -> {
        ExporterCfg exporterCfg = new ExporterCfg();
        exporterCfg.setClassName(RecordingExporter.class.getName());
        cfg.getExporters().put("test-recorder", exporterCfg);
    };
    public static final Consumer<BrokerCfg> DISABLE_EMBEDDED_GATEWAY = cfg -> cfg.getGateway().setEnable(false);

    public static Consumer<BrokerCfg> setPartitionCount(int partitionCount) {
        return cfg -> cfg.getCluster().setPartitionsCount(partitionCount);
    }

    public static Consumer<BrokerCfg> setCluster(int nodeId, int partitionCount, int replicationFactor, int clusterSize, String clusterName) {
        return cfg -> {
            ClusterCfg cluster = cfg.getCluster();
            cluster.setNodeId(nodeId);
            cluster.setPartitionsCount(partitionCount);
            cluster.setReplicationFactor(replicationFactor);
            cluster.setClusterSize(clusterSize);
            cluster.setClusterName(clusterName);
            cluster.getMembership().setFailureTimeout(Duration.ofMillis(2000L));
            cluster.getMembership().setGossipInterval(Duration.ofMillis(150L));
            cluster.getMembership().setProbeInterval(Duration.ofMillis(250L));
            cluster.getMembership().setProbeInterval(Duration.ofMillis(250L));
        };
    }

    public static Consumer<BrokerCfg> setInitialContactPoints(String ... contactPoints) {
        return cfg -> cfg.getCluster().setInitialContactPoints(Arrays.asList(contactPoints));
    }

    public static Consumer<BrokerCfg> setGatewayApiPort(int port) {
        return cfg -> cfg.getGateway().getNetwork().setPort(port);
    }

    public static Consumer<BrokerCfg> setGatewayClusterPort(int port) {
        return cfg -> cfg.getGateway().getCluster().setPort(port);
    }

    public static Consumer<BrokerCfg> setCommandApiPort(int port) {
        return cfg -> cfg.getNetwork().getCommandApi().setPort(port);
    }

    public static Consumer<BrokerCfg> setInternalApiPort(int port) {
        return cfg -> cfg.getNetwork().getInternalApi().setPort(port);
    }
}

