/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.test;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.FeatureFlagsCfg;
import io.camunda.zeebe.broker.system.configuration.ThreadsCfg;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.scheduler.clock.DefaultActorClock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;

public final class TestActorSchedulerFactory {
    private TestActorSchedulerFactory() {
    }

    public static ActorScheduler ofBrokerConfig(BrokerCfg config) {
        return TestActorSchedulerFactory.ofBrokerConfig(config, (ActorClock)new DefaultActorClock());
    }

    public static ActorScheduler ofBrokerConfig(BrokerCfg config, ActorClock clock) {
        ThreadsCfg threads = config.getThreads();
        FeatureFlagsCfg features = config.getExperimental().getFeatures();
        ActorScheduler scheduler = ActorScheduler.newActorScheduler().setCpuBoundActorThreadCount(threads.getCpuThreadCount()).setIoBoundActorThreadCount(threads.getIoThreadCount()).setMeterRegistry((MeterRegistry)(features.isEnableActorMetrics() ? new SimpleMeterRegistry() : null)).setActorClock(clock).build();
        scheduler.start();
        return scheduler;
    }
}

