/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.test;

import io.atomix.cluster.AtomixCluster;
import io.atomix.utils.event.EventListener;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.broker.client.api.BrokerClientRequestMetrics;
import io.camunda.zeebe.broker.client.api.BrokerClientTopologyMetrics;
import io.camunda.zeebe.broker.client.api.BrokerTopologyManager;
import io.camunda.zeebe.broker.client.impl.BrokerClientImpl;
import io.camunda.zeebe.broker.client.impl.BrokerTopologyManagerImpl;
import io.camunda.zeebe.gateway.impl.configuration.ConfigurationDefaults;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;

public final class TestBrokerClientFactory {
    public static BrokerClient createBrokerClient(AtomixCluster atomixCluster, ActorScheduler actorScheduler) {
        SimpleMeterRegistry meterRegistry = new SimpleMeterRegistry();
        BrokerTopologyManagerImpl topologyManager = new BrokerTopologyManagerImpl(() -> atomixCluster.getMembershipService().getMembers(), BrokerClientTopologyMetrics.of((MeterRegistry)meterRegistry));
        actorScheduler.submitActor((Actor)topologyManager).join();
        atomixCluster.getMembershipService().addListener((EventListener)topologyManager);
        BrokerClientImpl client = new BrokerClientImpl(ConfigurationDefaults.DEFAULT_REQUEST_TIMEOUT, atomixCluster.getMessagingService(), atomixCluster.getEventService(), (ActorSchedulingService)actorScheduler, (BrokerTopologyManager)topologyManager, BrokerClientRequestMetrics.of((MeterRegistry)meterRegistry));
        client.start().forEach(ActorFuture::join);
        return client;
    }
}

