/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport;

import io.camunda.zeebe.broker.transport.AsyncApiRequestHandler;
import io.camunda.zeebe.broker.transport.ErrorResponseWriter;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.scheduler.testing.ControlledActorSchedulerExtension;
import io.camunda.zeebe.transport.ServerOutput;
import io.camunda.zeebe.util.Either;
import java.util.function.Supplier;
import org.agrona.DirectBuffer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.Mockito;

final class ApiRequestHandlerTest {
    @RegisterExtension
    public final ControlledActorSchedulerExtension actorScheduler = new ControlledActorSchedulerExtension();

    ApiRequestHandlerTest() {
    }

    @Test
    void shouldReadRequestBuffer() {
        AsyncApiRequestHandler.RequestReader reader = (AsyncApiRequestHandler.RequestReader)Mockito.mock(AsyncApiRequestHandler.RequestReader.class);
        AsyncApiRequestHandler.ResponseWriter writer = (AsyncApiRequestHandler.ResponseWriter)Mockito.mock(AsyncApiRequestHandler.ResponseWriter.class);
        TestApiRequestHandler handler = new TestApiRequestHandler(() -> reader, () -> writer);
        this.actorScheduler.submitActor((Actor)handler);
        DirectBuffer buffer = (DirectBuffer)Mockito.mock(DirectBuffer.class);
        ServerOutput output = (ServerOutput)Mockito.mock(ServerOutput.class);
        handler.onRequest(output, 0, 0L, buffer, 0, 1);
        this.actorScheduler.workUntilDone();
        ((AsyncApiRequestHandler.RequestReader)Mockito.verify((Object)reader)).wrap(buffer, 0, 1);
    }

    @Test
    void shouldResetReaderAndWriter() {
        AsyncApiRequestHandler.RequestReader reader = (AsyncApiRequestHandler.RequestReader)Mockito.mock(AsyncApiRequestHandler.RequestReader.class);
        AsyncApiRequestHandler.ResponseWriter writer = (AsyncApiRequestHandler.ResponseWriter)Mockito.mock(AsyncApiRequestHandler.ResponseWriter.class);
        TestApiRequestHandler handler = new TestApiRequestHandler(() -> reader, () -> writer);
        this.actorScheduler.submitActor((Actor)handler);
        DirectBuffer buffer = (DirectBuffer)Mockito.mock(DirectBuffer.class);
        ServerOutput output = (ServerOutput)Mockito.mock(ServerOutput.class);
        handler.onRequest(output, 0, 0L, buffer, 0, 1);
        this.actorScheduler.workUntilDone();
        ((AsyncApiRequestHandler.RequestReader)Mockito.verify((Object)reader)).reset();
        ((AsyncApiRequestHandler.ResponseWriter)Mockito.verify((Object)writer)).reset();
    }

    @Test
    void shouldWriteResponse() {
        AsyncApiRequestHandler.RequestReader reader = (AsyncApiRequestHandler.RequestReader)Mockito.mock(AsyncApiRequestHandler.RequestReader.class);
        AsyncApiRequestHandler.ResponseWriter writer = (AsyncApiRequestHandler.ResponseWriter)Mockito.mock(AsyncApiRequestHandler.ResponseWriter.class);
        TestApiRequestHandler handler = new TestApiRequestHandler(() -> reader, () -> writer);
        this.actorScheduler.submitActor((Actor)handler);
        DirectBuffer buffer = (DirectBuffer)Mockito.mock(DirectBuffer.class);
        ServerOutput output = (ServerOutput)Mockito.mock(ServerOutput.class);
        int partitionId = 12;
        int requestId = 34;
        ((DirectBuffer)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)buffer)).wrap(buffer, 0, 1);
        handler.onRequest(output, 12, 34L, buffer, 0, 1);
        this.actorScheduler.workUntilDone();
        ((AsyncApiRequestHandler.ResponseWriter)Mockito.verify((Object)writer)).tryWriteResponse(output, 12, 34L);
    }

    private static class TestApiRequestHandler
    extends AsyncApiRequestHandler<AsyncApiRequestHandler.RequestReader<?>, AsyncApiRequestHandler.ResponseWriter> {
        TestApiRequestHandler(Supplier<AsyncApiRequestHandler.RequestReader<?>> requestReaderSupplier, Supplier<AsyncApiRequestHandler.ResponseWriter> responseWriterSupplier) {
            super(requestReaderSupplier, responseWriterSupplier);
        }

        protected ActorFuture<Either<ErrorResponseWriter, AsyncApiRequestHandler.ResponseWriter>> handleAsync(int partitionId, long requestId, AsyncApiRequestHandler.RequestReader<?> requestReader, AsyncApiRequestHandler.ResponseWriter responseWriter, ErrorResponseWriter errorWriter) {
            return CompletableActorFuture.completed((Object)Either.right((Object)responseWriter));
        }
    }
}

