/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.adminapi;

import io.atomix.raft.RaftServer;
import io.atomix.raft.partition.RaftPartition;
import io.camunda.zeebe.broker.partitioning.PartitionAdminAccess;
import io.camunda.zeebe.broker.transport.adminapi.AdminApiRequestHandler;
import io.camunda.zeebe.protocol.impl.encoding.AdminRequest;
import io.camunda.zeebe.protocol.impl.encoding.AdminResponse;
import io.camunda.zeebe.protocol.impl.encoding.ErrorResponse;
import io.camunda.zeebe.protocol.management.AdminRequestType;
import io.camunda.zeebe.protocol.record.ErrorCode;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.scheduler.testing.ControlledActorSchedulerExtension;
import io.camunda.zeebe.transport.ServerOutput;
import io.camunda.zeebe.transport.impl.AtomixServerTransport;
import io.camunda.zeebe.util.Either;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.CONCURRENT)
final class AdminApiRequestHandlerTest {
    AdminApiRequestHandlerTest() {
    }

    private CompletableFuture<Either<ErrorResponse, AdminResponse>> handleRequest(AdminRequest request, AdminApiRequestHandler handler) {
        CompletableFuture<Either<ErrorResponse, AdminResponse>> future = new CompletableFuture<Either<ErrorResponse, AdminResponse>>();
        ServerOutput serverOutput = this.createServerOutput(future);
        UnsafeBuffer requestBuffer = new UnsafeBuffer(new byte[request.getLength()]);
        request.write((MutableDirectBuffer)requestBuffer, 0);
        handler.onRequest(serverOutput, request.getPartitionId(), 0L, (DirectBuffer)requestBuffer, 0, request.getLength());
        return future;
    }

    private ServerOutput createServerOutput(CompletableFuture<Either<ErrorResponse, AdminResponse>> future) {
        return serverResponse -> {
            ExpandableArrayBuffer buffer = new ExpandableArrayBuffer();
            serverResponse.write((MutableDirectBuffer)buffer, 0);
            ErrorResponse error = new ErrorResponse();
            if (error.tryWrap((DirectBuffer)buffer)) {
                error.wrap((DirectBuffer)buffer, 0, serverResponse.getLength());
                future.complete(Either.left((Object)error));
                return;
            }
            AdminResponse response = new AdminResponse();
            try {
                response.wrap((DirectBuffer)buffer, 0, serverResponse.getLength());
                future.complete(Either.right((Object)response));
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        };
    }

    private static void assertErrorCode(CompletableFuture<Either<ErrorResponse, AdminResponse>> response, ErrorCode expectedErrorCode) {
        ((ObjectAssert)Assertions.assertThat(response).succeedsWithin(Duration.ofMinutes(1L)).matches(Either::isLeft)).extracting(Either::getLeft).extracting(ErrorResponse::getErrorCode).isEqualTo((Object)expectedErrorCode);
    }

    @Nested
    @ExtendWith(value={MockitoExtension.class})
    final class StepdownRequest {
        @RegisterExtension
        final ControlledActorSchedulerExtension scheduler = new ControlledActorSchedulerExtension();
        private final AdminApiRequestHandler handler;
        private final RaftPartition raftPartition;

        StepdownRequest(@Mock AtomixServerTransport transport, @Mock(answer=Answers.RETURNS_MOCKS) PartitionAdminAccess adminAccess, RaftPartition raftPartition) {
            this.raftPartition = raftPartition;
            this.handler = new AdminApiRequestHandler(transport, adminAccess, raftPartition);
        }

        @BeforeEach
        void installHandler() {
            this.scheduler.submitActor((Actor)this.handler);
            this.scheduler.workUntilDone();
        }

        @Test
        void shouldInitiateStepdown() {
            Mockito.when((Object)this.raftPartition.getRole()).thenReturn((Object)RaftServer.Role.LEADER);
            AdminRequest request = new AdminRequest();
            request.setType(AdminRequestType.STEP_DOWN_IF_NOT_PRIMARY);
            CompletableFuture<Either<ErrorResponse, AdminResponse>> responseFuture = AdminApiRequestHandlerTest.this.handleRequest(request, this.handler);
            this.scheduler.workUntilDone();
            Assertions.assertThat(responseFuture).succeedsWithin(Duration.ofMinutes(1L)).matches(Either::isRight);
        }

        @Test
        void shouldRejectRequestWhenNoPartitionsAreKnown() {
            AdminRequest request = new AdminRequest();
            request.setType(AdminRequestType.STEP_DOWN_IF_NOT_PRIMARY);
            CompletableFuture<Either<ErrorResponse, AdminResponse>> responseFuture = AdminApiRequestHandlerTest.this.handleRequest(request, this.handler);
            this.scheduler.workUntilDone();
            AdminApiRequestHandlerTest.assertErrorCode(responseFuture, ErrorCode.PARTITION_LEADER_MISMATCH);
        }

        @Test
        void shouldRejectRequestWhenNotLeader() {
            Mockito.when((Object)this.raftPartition.getRole()).thenReturn((Object)RaftServer.Role.FOLLOWER);
            AdminRequest request = new AdminRequest();
            request.setType(AdminRequestType.STEP_DOWN_IF_NOT_PRIMARY);
            CompletableFuture<Either<ErrorResponse, AdminResponse>> responseFuture = AdminApiRequestHandlerTest.this.handleRequest(request, this.handler);
            this.scheduler.workUntilDone();
            AdminApiRequestHandlerTest.assertErrorCode(responseFuture, ErrorCode.PARTITION_LEADER_MISMATCH);
        }
    }

    @Nested
    @ExtendWith(value={MockitoExtension.class})
    final class ResumeExportingRequest {
        @RegisterExtension
        final ControlledActorSchedulerExtension scheduler = new ControlledActorSchedulerExtension();
        final AdminRequest request;
        private final PartitionAdminAccess adminAccess;
        private final AdminApiRequestHandler handler;

        public ResumeExportingRequest(@Mock(answer=Answers.RETURNS_MOCKS) PartitionAdminAccess adminAccess, @Mock RaftPartition raftPartition, AtomixServerTransport transport) {
            this.adminAccess = adminAccess;
            boolean partitionId = true;
            Mockito.when((Object)adminAccess.forPartition(1)).thenReturn(Optional.of(adminAccess));
            this.handler = new AdminApiRequestHandler(transport, adminAccess, raftPartition);
            this.request = new AdminRequest();
            this.request.setPartitionId(1);
            this.request.setType(AdminRequestType.RESUME_EXPORTING);
        }

        @BeforeEach
        void startHandler() {
            this.scheduler.submitActor((Actor)this.handler);
            this.scheduler.workUntilDone();
        }

        @Test
        void shouldResumeExportingForGivenPartition() {
            Mockito.when((Object)this.adminAccess.resumeExporting()).thenReturn((Object)CompletableActorFuture.completed(null));
            CompletableFuture<Either<ErrorResponse, AdminResponse>> responseFuture = AdminApiRequestHandlerTest.this.handleRequest(this.request, this.handler);
            this.scheduler.workUntilDone();
            Assertions.assertThat(responseFuture).succeedsWithin(Duration.ofMinutes(1L)).matches(Either::isRight);
            ((PartitionAdminAccess)Mockito.verify((Object)this.adminAccess)).forPartition(this.request.getPartitionId());
            ((PartitionAdminAccess)Mockito.verify((Object)this.adminAccess)).resumeExporting();
        }

        @Test
        void shouldRespondWithFailureIfPausingFails() {
            Mockito.when((Object)this.adminAccess.resumeExporting()).thenReturn((Object)CompletableActorFuture.completedExceptionally((Throwable)new RuntimeException("Exporting fails")));
            CompletableFuture<Either<ErrorResponse, AdminResponse>> responseFuture = AdminApiRequestHandlerTest.this.handleRequest(this.request, this.handler);
            this.scheduler.workUntilDone();
            AdminApiRequestHandlerTest.assertErrorCode(responseFuture, ErrorCode.INTERNAL_ERROR);
        }

        @Test
        void shouldRespondWithFailureIfPartitionNotFound() {
            this.request.setPartitionId(5);
            CompletableFuture<Either<ErrorResponse, AdminResponse>> responseFuture = AdminApiRequestHandlerTest.this.handleRequest(this.request, this.handler);
            this.scheduler.workUntilDone();
            AdminApiRequestHandlerTest.assertErrorCode(responseFuture, ErrorCode.INTERNAL_ERROR);
        }
    }

    @Nested
    @ExtendWith(value={MockitoExtension.class})
    final class SoftPauseExportingRequest {
        @RegisterExtension
        final ControlledActorSchedulerExtension scheduler = new ControlledActorSchedulerExtension();
        private final PartitionAdminAccess adminAccess;
        private final AdminApiRequestHandler handler;
        private final AdminRequest request;

        public SoftPauseExportingRequest(@Mock(answer=Answers.RETURNS_MOCKS) PartitionAdminAccess adminAccess, @Mock RaftPartition raftPartition, AtomixServerTransport transport) {
            this.adminAccess = adminAccess;
            boolean partitionId = true;
            Mockito.when((Object)adminAccess.forPartition(1)).thenReturn(Optional.of(adminAccess));
            this.handler = new AdminApiRequestHandler(transport, adminAccess, raftPartition);
            this.request = new AdminRequest();
            this.request.setPartitionId(1);
            this.request.setType(AdminRequestType.SOFT_PAUSE_EXPORTING);
        }

        @BeforeEach
        void startHandler() {
            this.scheduler.submitActor((Actor)this.handler);
            this.scheduler.workUntilDone();
        }

        @Test
        void shouldSoftPauseExportingForGivenPartition() {
            Mockito.when((Object)this.adminAccess.softPauseExporting()).thenReturn((Object)CompletableActorFuture.completed(null));
            CompletableFuture<Either<ErrorResponse, AdminResponse>> responseFuture = AdminApiRequestHandlerTest.this.handleRequest(this.request, this.handler);
            this.scheduler.workUntilDone();
            Assertions.assertThat(responseFuture).succeedsWithin(Duration.ofMinutes(1L)).matches(Either::isRight);
            ((PartitionAdminAccess)Mockito.verify((Object)this.adminAccess)).forPartition(this.request.getPartitionId());
            ((PartitionAdminAccess)Mockito.verify((Object)this.adminAccess)).softPauseExporting();
        }

        @Test
        void shouldRespondWithFailureIfPausingFails() {
            Mockito.when((Object)this.adminAccess.softPauseExporting()).thenReturn((Object)CompletableActorFuture.completedExceptionally((Throwable)new RuntimeException("Exporting fails")));
            CompletableFuture<Either<ErrorResponse, AdminResponse>> responseFuture = AdminApiRequestHandlerTest.this.handleRequest(this.request, this.handler);
            this.scheduler.workUntilDone();
            AdminApiRequestHandlerTest.assertErrorCode(responseFuture, ErrorCode.INTERNAL_ERROR);
        }

        @Test
        void shouldRespondWithFailureIfPartitionNotFound() {
            this.request.setPartitionId(5);
            CompletableFuture<Either<ErrorResponse, AdminResponse>> responseFuture = AdminApiRequestHandlerTest.this.handleRequest(this.request, this.handler);
            this.scheduler.workUntilDone();
            AdminApiRequestHandlerTest.assertErrorCode(responseFuture, ErrorCode.INTERNAL_ERROR);
        }
    }

    @Nested
    @ExtendWith(value={MockitoExtension.class})
    final class PauseExportingRequest {
        @RegisterExtension
        final ControlledActorSchedulerExtension scheduler = new ControlledActorSchedulerExtension();
        private final PartitionAdminAccess adminAccess;
        private final AdminApiRequestHandler handler;
        private final AdminRequest request;

        public PauseExportingRequest(@Mock(answer=Answers.RETURNS_MOCKS) PartitionAdminAccess adminAccess, @Mock RaftPartition raftPartition, AtomixServerTransport transport) {
            this.adminAccess = adminAccess;
            boolean partitionId = true;
            Mockito.when((Object)adminAccess.forPartition(1)).thenReturn(Optional.of(adminAccess));
            this.handler = new AdminApiRequestHandler(transport, adminAccess, raftPartition);
            this.request = new AdminRequest();
            this.request.setPartitionId(1);
            this.request.setType(AdminRequestType.PAUSE_EXPORTING);
        }

        @BeforeEach
        void startHandler() {
            this.scheduler.submitActor((Actor)this.handler);
            this.scheduler.workUntilDone();
        }

        @Test
        void shouldPauseExportingForGivenPartition() {
            Mockito.when((Object)this.adminAccess.pauseExporting()).thenReturn((Object)CompletableActorFuture.completed(null));
            CompletableFuture<Either<ErrorResponse, AdminResponse>> responseFuture = AdminApiRequestHandlerTest.this.handleRequest(this.request, this.handler);
            this.scheduler.workUntilDone();
            Assertions.assertThat(responseFuture).succeedsWithin(Duration.ofMinutes(1L)).matches(Either::isRight);
            ((PartitionAdminAccess)Mockito.verify((Object)this.adminAccess)).forPartition(this.request.getPartitionId());
            ((PartitionAdminAccess)Mockito.verify((Object)this.adminAccess)).pauseExporting();
        }

        @Test
        void shouldRespondWithFailureIfPausingFails() {
            Mockito.when((Object)this.adminAccess.pauseExporting()).thenReturn((Object)CompletableActorFuture.completedExceptionally((Throwable)new RuntimeException("Exporting fails")));
            CompletableFuture<Either<ErrorResponse, AdminResponse>> responseFuture = AdminApiRequestHandlerTest.this.handleRequest(this.request, this.handler);
            this.scheduler.workUntilDone();
            AdminApiRequestHandlerTest.assertErrorCode(responseFuture, ErrorCode.INTERNAL_ERROR);
        }

        @Test
        void shouldRespondWithFailureIfPartitionNotFound() {
            this.request.setPartitionId(5);
            CompletableFuture<Either<ErrorResponse, AdminResponse>> responseFuture = AdminApiRequestHandlerTest.this.handleRequest(this.request, this.handler);
            this.scheduler.workUntilDone();
            AdminApiRequestHandlerTest.assertErrorCode(responseFuture, ErrorCode.INTERNAL_ERROR);
        }
    }

    @Nested
    @ExtendWith(value={MockitoExtension.class})
    final class OtherRequest {
        @RegisterExtension
        final ControlledActorSchedulerExtension scheduler = new ControlledActorSchedulerExtension();
        private final AdminApiRequestHandler handler;

        OtherRequest(@Mock AtomixServerTransport transport, @Mock(answer=Answers.RETURNS_MOCKS) PartitionAdminAccess adminAccess, RaftPartition raftPartition) {
            this.handler = new AdminApiRequestHandler(transport, adminAccess, raftPartition);
        }

        @BeforeEach
        void installHandler() {
            this.scheduler.submitActor((Actor)this.handler);
            this.scheduler.workUntilDone();
        }

        @Test
        void shouldRejectRequestWithInvalidType() {
            AdminRequest request = new AdminRequest();
            request.setType(AdminRequestType.NULL_VAL);
            CompletableFuture<Either<ErrorResponse, AdminResponse>> responseFuture = AdminApiRequestHandlerTest.this.handleRequest(request, this.handler);
            this.scheduler.workUntilDone();
            AdminApiRequestHandlerTest.assertErrorCode(responseFuture, ErrorCode.UNSUPPORTED_MESSAGE);
        }
    }
}

