/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.backpressure;

import io.camunda.zeebe.broker.system.configuration.backpressure.BackpressureCfg;
import io.camunda.zeebe.broker.transport.backpressure.PartitionAwareRequestLimiter;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

final class PartitionAwareRateLimiterTest {
    private static final int PARTITIONS = 3;
    private final Intent context = ProcessInstanceCreationIntent.CREATE;
    private PartitionAwareRequestLimiter partitionedLimiter;

    PartitionAwareRateLimiterTest() {
    }

    @BeforeEach
    void setUp() {
        BackpressureCfg backpressureCfg = new BackpressureCfg();
        backpressureCfg.setAlgorithm("fixed");
        backpressureCfg.getFixed().setLimit(1);
        this.partitionedLimiter = PartitionAwareRequestLimiter.newLimiter((BackpressureCfg)backpressureCfg, (MeterRegistry)new SimpleMeterRegistry());
        IntStream.range(0, 3).forEach(arg_0 -> ((PartitionAwareRequestLimiter)this.partitionedLimiter).addPartition(arg_0));
    }

    @Test
    void shouldNotBlockRequestsOnOtherPartitionsWhenOnePartitionIsFull() {
        Assertions.assertThat((boolean)this.partitionedLimiter.tryAcquire(0, 0, 1L, this.context)).isTrue();
        Assertions.assertThat((boolean)this.partitionedLimiter.tryAcquire(0, 0, 2L, this.context)).isFalse();
        IntStream.range(1, 3).forEach(i -> Assertions.assertThat((boolean)this.partitionedLimiter.tryAcquire(i, 0, 1L, this.context)).isTrue());
    }

    @Test
    void shouldUpdateOnResponse() {
        this.partitionedLimiter.tryAcquire(0, 0, 1L, this.context);
        Assertions.assertThat((boolean)this.partitionedLimiter.tryAcquire(0, 0, 2L, this.context)).isFalse();
        this.partitionedLimiter.onResponse(0, 0, 1L);
        Assertions.assertThat((boolean)this.partitionedLimiter.tryAcquire(0, 0, 2L, this.context)).isTrue();
    }

    @Test
    void shouldNotUpdateOnResponseDifferentPartition() {
        boolean mainPartitionId = false;
        boolean otherPartitionId = true;
        this.partitionedLimiter.tryAcquire(0, 0, 1L, this.context);
        this.partitionedLimiter.tryAcquire(1, 0, 1L, this.context);
        Assertions.assertThat((boolean)this.partitionedLimiter.tryAcquire(0, 0, 2L, this.context)).isFalse();
        this.partitionedLimiter.onResponse(1, 0, 1L);
        Assertions.assertThat((boolean)this.partitionedLimiter.tryAcquire(0, 0, 2L, this.context)).isFalse();
    }

    @Test
    void shouldCreateNewLimiterOnReAddingPartitionWithoutExplicitRemove() {
        boolean partitionId = false;
        this.partitionedLimiter.tryAcquire(0, 0, 1L, this.context);
        Assertions.assertThat((boolean)this.partitionedLimiter.tryAcquire(0, 0, 2L, this.context)).isFalse();
        this.partitionedLimiter.addPartition(0);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.partitionedLimiter.tryAcquire(0, 0, 2L, this.context)).describedAs("Should not reject request on re-added partition", new Object[0])).isTrue();
    }
}

