/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.backpressure;

import io.camunda.zeebe.broker.transport.backpressure.StabilizingAIMDLimit;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StabilizingAIMDLimitTest {
    private final StabilizingAIMDLimit limit = StabilizingAIMDLimit.newBuilder().initialLimit(10).minLimit(1).expectedRTT(1L, TimeUnit.SECONDS).build();

    StabilizingAIMDLimitTest() {
    }

    @Test
    void shouldIncreaseLimitOnLowerRtt() {
        this.limit.onSample(0L, TimeUnit.MILLISECONDS.toNanos(1L), 9, false);
        Assertions.assertThat((int)this.limit.getLimit()).isEqualTo(11);
    }

    @Test
    void shouldNotIncreaseLimitWhenLowInflight() {
        this.limit.onSample(0L, TimeUnit.MILLISECONDS.toNanos(1L), 2, false);
        Assertions.assertThat((int)this.limit.getLimit()).isEqualTo(10);
    }

    @Test
    void shouldDecreaseLimitOnHigherRtt() {
        this.limit.onSample(0L, TimeUnit.SECONDS.toNanos(2L), 9, false);
        Assertions.assertThat((int)this.limit.getLimit()).isEqualTo(9);
    }

    @Test
    void shouldNotDecreaseLimitWhenInflightGreaterThanLimit() {
        this.limit.onSample(0L, TimeUnit.SECONDS.toNanos(2L), 11, false);
        Assertions.assertThat((int)this.limit.getLimit()).isEqualTo(10);
    }
}

