/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.backupapi;

import io.camunda.zeebe.backup.api.BackupIdentifier;
import io.camunda.zeebe.backup.api.BackupManager;
import io.camunda.zeebe.backup.api.BackupStatus;
import io.camunda.zeebe.backup.api.BackupStatusCode;
import io.camunda.zeebe.backup.common.BackupDescriptorImpl;
import io.camunda.zeebe.backup.common.BackupIdentifierImpl;
import io.camunda.zeebe.backup.common.BackupStatusImpl;
import io.camunda.zeebe.broker.transport.backupapi.BackupApiRequestHandler;
import io.camunda.zeebe.logstreams.log.LogAppendEntry;
import io.camunda.zeebe.logstreams.log.LogStreamWriter;
import io.camunda.zeebe.protocol.impl.encoding.BackupListResponse;
import io.camunda.zeebe.protocol.impl.encoding.BackupRequest;
import io.camunda.zeebe.protocol.impl.encoding.BackupStatusResponse;
import io.camunda.zeebe.protocol.impl.encoding.ErrorResponse;
import io.camunda.zeebe.protocol.management.BackupRequestType;
import io.camunda.zeebe.protocol.management.BackupStatusResponseEncoder;
import io.camunda.zeebe.protocol.record.ErrorCode;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.scheduler.testing.ControlledActorSchedulerExtension;
import io.camunda.zeebe.test.util.junit.RegressionTest;
import io.camunda.zeebe.transport.ServerOutput;
import io.camunda.zeebe.transport.ServerResponse;
import io.camunda.zeebe.transport.impl.AtomixServerTransport;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.IntStream;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
final class BackupApiRequestHandlerTest {
    @RegisterExtension
    ControlledActorSchedulerExtension scheduler = new ControlledActorSchedulerExtension();
    @Mock
    AtomixServerTransport transport;
    @Mock(answer=Answers.RETURNS_SELF)
    LogStreamWriter logStreamWriter;
    @Mock
    BackupManager backupManager;
    BackupApiRequestHandler handler;
    private ResponseReader serverOutput;
    private CompletableFuture<Either<ErrorResponse, BufferReader>> responseFuture;

    BackupApiRequestHandlerTest() {
    }

    @BeforeEach
    void setup() {
        this.handler = new BackupApiRequestHandler(this.transport, this.logStreamWriter, this.backupManager, 1, true);
        this.scheduler.submitActor((Actor)this.handler);
        this.scheduler.workUntilDone();
        this.serverOutput = new ResponseReader();
        this.responseFuture = new CompletableFuture();
    }

    @Test
    void shouldRejectRequestWithInvalidType() {
        BackupRequest request = new BackupRequest().setType(BackupRequestType.NULL_VAL).setPartitionId(1).setBackupId(10L);
        this.handleRequest(request);
        ((ObjectAssert)Assertions.assertThat(this.responseFuture).succeedsWithin(Duration.ofMinutes(1L)).matches(Either::isLeft)).extracting(Either::getLeft).extracting(ErrorResponse::getErrorCode).isEqualTo((Object)ErrorCode.UNSUPPORTED_MESSAGE);
    }

    @Test
    void shouldWriteToLogstreamOnTakeBackupRequest() {
        BackupRequest request = new BackupRequest().setType(BackupRequestType.TAKE_BACKUP).setPartitionId(1).setBackupId(10L);
        this.handleRequest(request);
        ((LogStreamWriter)Mockito.verify((Object)this.logStreamWriter, (VerificationMode)Mockito.times((int)1))).tryWrite((LogAppendEntry)ArgumentMatchers.any(LogAppendEntry.class));
    }

    @Test
    void shouldNotWriteWhenNoDiskSpace() {
        BackupRequest request = new BackupRequest().setType(BackupRequestType.TAKE_BACKUP).setPartitionId(1).setBackupId(10L);
        this.handler.onDiskSpaceNotAvailable();
        this.scheduler.workUntilDone();
        this.handleRequest(request);
        ((ObjectAssert)Assertions.assertThat(this.responseFuture).succeedsWithin(Duration.ofMinutes(1L)).matches(Either::isLeft)).extracting(Either::getLeft).extracting(ErrorResponse::getErrorCode).isEqualTo((Object)ErrorCode.RESOURCE_EXHAUSTED);
        ((LogStreamWriter)Mockito.verify((Object)this.logStreamWriter, (VerificationMode)Mockito.never())).tryWrite((LogAppendEntry)ArgumentMatchers.any(LogAppendEntry.class));
    }

    @Test
    void shouldWriteWhenDiskSpaceAvailableAgain() {
        BackupRequest request = new BackupRequest().setType(BackupRequestType.TAKE_BACKUP).setPartitionId(1).setBackupId(10L);
        this.handler.onDiskSpaceNotAvailable();
        this.scheduler.workUntilDone();
        this.handler.onDiskSpaceAvailable();
        this.scheduler.workUntilDone();
        this.handleRequest(request);
        Assertions.assertThat(this.responseFuture).succeedsWithin(Duration.ofMillis(100L));
    }

    @Test
    void shouldCompleteResponseWhenStatusIsCompleted() {
        long checkpointId = 10L;
        BackupRequest request = new BackupRequest().setType(BackupRequestType.QUERY_STATUS).setPartitionId(1).setBackupId(10L);
        Instant createdAt = Instant.ofEpochMilli(1000L);
        Instant lastModified = Instant.ofEpochMilli(2000L);
        BackupStatusImpl status = new BackupStatusImpl((BackupIdentifier)new BackupIdentifierImpl(1, 1, 10L), Optional.of(new BackupDescriptorImpl(Optional.of("s-id"), 100L, 3, "test")), BackupStatusCode.COMPLETED, Optional.empty(), Optional.of(createdAt), Optional.of(lastModified));
        Mockito.when((Object)this.backupManager.getBackupStatus(10L)).thenReturn((Object)CompletableActorFuture.completed((Object)status));
        BackupStatusResponse statusResponse = new BackupStatusResponse();
        this.serverOutput.setResponseObject((BufferReader)statusResponse);
        this.handleRequest(request);
        Assertions.assertThat(this.responseFuture).succeedsWithin(Duration.ofMillis(100L)).matches(Either::isRight);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)statusResponse).returns((Object)10L, BackupStatusResponse::getBackupId)).returns((Object)1, BackupStatusResponse::getPartitionId)).returns((Object)1, BackupStatusResponse::getBrokerId)).returns((Object)100L, BackupStatusResponse::getCheckpointPosition)).returns((Object)3, BackupStatusResponse::getNumberOfPartitions)).returns((Object)"s-id", BackupStatusResponse::getSnapshotId)).returns((Object)io.camunda.zeebe.protocol.management.BackupStatusCode.COMPLETED, BackupStatusResponse::getStatus)).returns((Object)"test", BackupStatusResponse::getBrokerVersion)).returns((Object)createdAt.toString(), BackupStatusResponse::getCreatedAt)).returns((Object)lastModified.toString(), BackupStatusResponse::getLastUpdated)).matches(response -> response.getFailureReason().isEmpty());
    }

    @Test
    void shouldCompleteResponseWhenStatusIsFailed() {
        long checkpointId = 10L;
        BackupRequest request = new BackupRequest().setType(BackupRequestType.QUERY_STATUS).setPartitionId(1).setBackupId(10L);
        BackupStatusImpl status = new BackupStatusImpl((BackupIdentifier)new BackupIdentifierImpl(1, 1, 10L), Optional.empty(), BackupStatusCode.FAILED, Optional.of("Expected"), Optional.empty(), Optional.empty());
        Mockito.when((Object)this.backupManager.getBackupStatus(10L)).thenReturn((Object)CompletableActorFuture.completed((Object)status));
        BackupStatusResponse statusResponse = new BackupStatusResponse();
        this.serverOutput.setResponseObject((BufferReader)statusResponse);
        this.handleRequest(request);
        Assertions.assertThat(this.responseFuture).succeedsWithin(Duration.ofMillis(100L)).matches(Either::isRight);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)statusResponse).returns((Object)10L, BackupStatusResponse::getBackupId)).returns((Object)1, BackupStatusResponse::getPartitionId)).returns((Object)1, BackupStatusResponse::getBrokerId)).returns((Object)BackupStatusResponseEncoder.backupIdNullValue(), BackupStatusResponse::getCheckpointPosition)).returns((Object)BackupStatusResponseEncoder.numberOfPartitionsNullValue(), BackupStatusResponse::getNumberOfPartitions)).returns(null, BackupStatusResponse::getSnapshotId)).returns((Object)io.camunda.zeebe.protocol.management.BackupStatusCode.FAILED, BackupStatusResponse::getStatus)).returns((Object)"Expected", BackupStatusResponse::getFailureReason);
    }

    @Test
    void shouldReturnErrorWhenQueryingStatusFailed() {
        long checkpointId = 10L;
        BackupRequest request = new BackupRequest().setType(BackupRequestType.QUERY_STATUS).setPartitionId(1).setBackupId(10L);
        Mockito.when((Object)this.backupManager.getBackupStatus(10L)).thenReturn((Object)CompletableActorFuture.completedExceptionally((Throwable)new RuntimeException("Expected")));
        this.handleRequest(request);
        ((ObjectAssert)Assertions.assertThat(this.responseFuture).succeedsWithin(Duration.ofMinutes(1L)).matches(Either::isLeft)).extracting(Either::getLeft).extracting(ErrorResponse::getErrorCode).isEqualTo((Object)ErrorCode.INTERNAL_ERROR);
    }

    @Test
    void shouldCompleteResponseWithBackupList() {
        BackupRequest request = new BackupRequest().setType(BackupRequestType.LIST).setPartitionId(1);
        Instant createdAt = Instant.ofEpochMilli(1000L);
        Instant lastModified = Instant.ofEpochMilli(2000L);
        BackupStatusImpl status = new BackupStatusImpl((BackupIdentifier)new BackupIdentifierImpl(1, 1, 2L), Optional.of(new BackupDescriptorImpl(Optional.of("s-id"), 100L, 3, "test")), BackupStatusCode.COMPLETED, Optional.empty(), Optional.of(createdAt), Optional.of(lastModified));
        Mockito.when((Object)this.backupManager.listBackups()).thenReturn((Object)CompletableActorFuture.completed(List.of(status)));
        BackupListResponse listResponse = new BackupListResponse(List.of());
        this.serverOutput.setResponseObject((BufferReader)listResponse);
        this.handleRequest(request);
        Assertions.assertThat(this.responseFuture).succeedsWithin(Duration.ofMillis(100L)).matches(Either::isRight);
        BackupListResponse.BackupStatus expected = new BackupListResponse.BackupStatus(2L, 1, io.camunda.zeebe.protocol.management.BackupStatusCode.COMPLETED, "", "test", createdAt.toString());
        Assertions.assertThat((List)listResponse.getBackups()).containsExactly((Object[])new BackupListResponse.BackupStatus[]{expected});
    }

    @RegressionTest(value="https://github.com/camunda/zeebe/issues/12597")
    void shouldListManyBackups() {
        BackupRequest request = new BackupRequest().setType(BackupRequestType.LIST).setPartitionId(1);
        List<BackupStatus> statuses = IntStream.range(0, 500).mapToObj(i -> new BackupStatusImpl((BackupIdentifier)new BackupIdentifierImpl(1, 1, (long)i), Optional.empty(), BackupStatusCode.FAILED, Optional.empty(), Optional.of(Instant.now()), Optional.of(Instant.now()))).toList();
        Mockito.when((Object)this.backupManager.listBackups()).thenReturn((Object)CompletableActorFuture.completed(statuses));
        BackupListResponse listResponse = new BackupListResponse(List.of());
        this.serverOutput.setResponseObject((BufferReader)listResponse);
        this.handleRequest(request);
        Assertions.assertThat(this.responseFuture).succeedsWithin(Duration.ofMillis(100L)).matches(Either::isRight);
        Assertions.assertThat((List)listResponse.getBackups()).hasSize(statuses.size());
    }

    @Test
    void shouldSendErrorResponseWhenListFailed() {
        BackupRequest request = new BackupRequest().setType(BackupRequestType.LIST).setPartitionId(1);
        Mockito.when((Object)this.backupManager.listBackups()).thenReturn((Object)CompletableActorFuture.completedExceptionally((Throwable)new RuntimeException("list failed")));
        this.handleRequest(request);
        ((ObjectAssert)Assertions.assertThat(this.responseFuture).succeedsWithin(Duration.ofMillis(100L)).matches(Either::isLeft)).extracting(Either::getLeft).returns((Object)ErrorCode.INTERNAL_ERROR, ErrorResponse::getErrorCode).returns((Object)"list failed", error -> BufferUtil.bufferAsString((DirectBuffer)error.getErrorData()));
    }

    @Test
    void shouldDeleteBackup() {
        BackupRequest request = new BackupRequest().setType(BackupRequestType.DELETE).setPartitionId(1);
        Mockito.when((Object)this.backupManager.deleteBackup(ArgumentMatchers.anyLong())).thenReturn((Object)CompletableActorFuture.completed(null));
        BackupStatusResponse statusResponse = new BackupStatusResponse();
        this.serverOutput.setResponseObject((BufferReader)statusResponse);
        this.handleRequest(request);
        Assertions.assertThat(this.responseFuture).succeedsWithin(Duration.ofMillis(100L)).matches(Either::isRight);
        Assertions.assertThat((Comparable)statusResponse.getStatus()).isEqualTo((Object)io.camunda.zeebe.protocol.management.BackupStatusCode.DOES_NOT_EXIST);
    }

    @Test
    void shouldReturnErrorWhenDeleteFails() {
        BackupRequest request = new BackupRequest().setType(BackupRequestType.DELETE).setPartitionId(1);
        Mockito.when((Object)this.backupManager.deleteBackup(ArgumentMatchers.anyLong())).thenReturn((Object)CompletableActorFuture.completedExceptionally((Throwable)new RuntimeException("Expected failure")));
        this.handleRequest(request);
        ((ObjectAssert)Assertions.assertThat(this.responseFuture).succeedsWithin(Duration.ofMillis(100L)).matches(Either::isLeft)).extracting(Either::getLeft).returns((Object)ErrorCode.INTERNAL_ERROR, ErrorResponse::getErrorCode).returns((Object)"Expected failure", error -> BufferUtil.bufferAsString((DirectBuffer)error.getErrorData()));
    }

    private void handleRequest(BackupRequest request) {
        UnsafeBuffer requestBuffer = new UnsafeBuffer(new byte[request.getLength()]);
        request.write((MutableDirectBuffer)requestBuffer, 0);
        this.handler.onRequest((ServerOutput)this.serverOutput, 1, 1L, (DirectBuffer)requestBuffer, 0, request.getLength());
        this.scheduler.workUntilDone();
    }

    final class ResponseReader
    implements ServerOutput {
        BufferReader responseWrapper;

        ResponseReader() {
        }

        void setResponseObject(BufferReader responseObject) {
            this.responseWrapper = responseObject;
        }

        public void sendResponse(ServerResponse serverResponse) {
            ExpandableArrayBuffer buffer = new ExpandableArrayBuffer();
            serverResponse.write((MutableDirectBuffer)buffer, 0);
            ErrorResponse error = new ErrorResponse();
            if (error.tryWrap((DirectBuffer)buffer)) {
                error.wrap((DirectBuffer)buffer, 0, serverResponse.getLength());
                BackupApiRequestHandlerTest.this.responseFuture.complete((Either<ErrorResponse, BufferReader>)Either.left((Object)error));
                return;
            }
            try {
                this.responseWrapper.wrap((DirectBuffer)buffer, 0, serverResponse.getLength());
                BackupApiRequestHandlerTest.this.responseFuture.complete((Either<ErrorResponse, BufferReader>)Either.right((Object)this.responseWrapper));
            }
            catch (Exception e) {
                BackupApiRequestHandlerTest.this.responseFuture.completeExceptionally(e);
            }
        }
    }
}

