/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.commandapi;

import io.camunda.zeebe.broker.transport.backpressure.NoopRequestLimiter;
import io.camunda.zeebe.broker.transport.backpressure.RequestLimiter;
import io.camunda.zeebe.broker.transport.commandapi.CommandApiRequestHandler;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerPublishMessageRequest;
import io.camunda.zeebe.logstreams.log.LogAppendEntry;
import io.camunda.zeebe.logstreams.log.LogStreamWriter;
import io.camunda.zeebe.protocol.impl.encoding.ErrorResponse;
import io.camunda.zeebe.protocol.impl.encoding.ExecuteCommandRequest;
import io.camunda.zeebe.protocol.impl.encoding.ExecuteCommandResponse;
import io.camunda.zeebe.protocol.impl.encoding.ExecuteQueryRequest;
import io.camunda.zeebe.protocol.record.ErrorCode;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.testing.ControlledActorSchedulerRule;
import io.camunda.zeebe.transport.ServerOutput;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class CommandApiRequestHandlerTest {
    @Rule
    public final ControlledActorSchedulerRule scheduler = new ControlledActorSchedulerRule();
    final CommandApiRequestHandler handler = new CommandApiRequestHandler((MeterRegistry)new SimpleMeterRegistry());
    private LogStreamWriter logStreamWriter;

    @Before
    public void setup() {
        this.scheduler.submitActor((Actor)this.handler);
        this.logStreamWriter = (LogStreamWriter)Mockito.mock(LogStreamWriter.class);
        this.handler.addPartition(0, this.logStreamWriter, (RequestLimiter)new NoopRequestLimiter());
        this.scheduler.workUntilDone();
    }

    @Test
    public void shouldRejectCommandWithInvalidTemplate() {
        ExecuteQueryRequest request = new ExecuteQueryRequest();
        CompletableFuture<Either<ErrorResponse, ExecuteCommandResponse>> responseFuture = this.handleRequest((BufferWriter)request);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat(responseFuture).succeedsWithin(Duration.ofMinutes(1L)).matches(Either::isLeft)).matches(Either::isLeft)).extracting(Either::getLeft).extracting(ErrorResponse::getErrorCode).isEqualTo((Object)ErrorCode.INVALID_MESSAGE_TEMPLATE);
    }

    @Test
    public void shouldRejectCommandIfNotLeader() {
        ExecuteCommandRequest request = new ExecuteCommandRequest();
        this.handler.removePartition(0);
        this.scheduler.workUntilDone();
        CompletableFuture<Either<ErrorResponse, ExecuteCommandResponse>> responseFuture = this.handleRequest((BufferWriter)request);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat(responseFuture).succeedsWithin(Duration.ofMinutes(1L)).matches(Either::isLeft)).matches(Either::isLeft)).extracting(Either::getLeft).extracting(ErrorResponse::getErrorCode).isEqualTo((Object)ErrorCode.PARTITION_LEADER_MISMATCH);
    }

    @Test
    public void shouldRejectCommandWithoutEvent() {
        ExecuteCommandRequest request = new ExecuteCommandRequest();
        CompletableFuture<Either<ErrorResponse, ExecuteCommandResponse>> responseFuture = this.handleRequest((BufferWriter)request);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat(responseFuture).succeedsWithin(Duration.ofMinutes(1L)).matches(Either::isLeft)).matches(Either::isLeft)).extracting(Either::getLeft).extracting(ErrorResponse::getErrorCode).isEqualTo((Object)ErrorCode.UNSUPPORTED_MESSAGE);
    }

    @Test
    public void shouldRejectCommandWithUnknownEvent() {
        ExecuteCommandRequest request = new ExecuteCommandRequest();
        request.setValueType(ValueType.ERROR);
        CompletableFuture<Either<ErrorResponse, ExecuteCommandResponse>> responseFuture = this.handleRequest((BufferWriter)request);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat(responseFuture).succeedsWithin(Duration.ofMinutes(1L)).matches(Either::isLeft)).matches(Either::isLeft)).extracting(Either::getLeft).extracting(ErrorResponse::getErrorCode).isEqualTo((Object)ErrorCode.UNSUPPORTED_MESSAGE);
    }

    @Test
    public void shouldRejectCommandIfResourcesExhausted() {
        RequestLimiter limiter = (RequestLimiter)Mockito.mock(RequestLimiter.class);
        Mockito.when((Object)limiter.tryAcquire(ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), (Object)((Intent)ArgumentMatchers.any()))).thenReturn((Object)false);
        this.handler.addPartition(0, (LogStreamWriter)Mockito.mock(LogStreamWriter.class), limiter);
        this.scheduler.workUntilDone();
        BrokerPublishMessageRequest request = new BrokerPublishMessageRequest("test", "1").setMessageId("1").setTimeToLive(0L);
        request.serializeValue();
        CompletableFuture<Either<ErrorResponse, ExecuteCommandResponse>> responseFuture = this.handleRequest((BufferWriter)request);
        ((ObjectAssert)Assertions.assertThat(responseFuture).succeedsWithin(Duration.ofMinutes(1L)).matches(Either::isLeft)).extracting(Either::getLeft).extracting(ErrorResponse::getErrorCode).isEqualTo((Object)ErrorCode.RESOURCE_EXHAUSTED);
    }

    @Test
    public void shouldWriteToLog() {
        LogStreamWriter logWriter = (LogStreamWriter)Mockito.mock(LogStreamWriter.class);
        Mockito.when((Object)logWriter.canWriteEvents(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn((Object)true);
        this.handler.addPartition(0, logWriter, (RequestLimiter)new NoopRequestLimiter());
        this.scheduler.workUntilDone();
        BrokerPublishMessageRequest request = new BrokerPublishMessageRequest("test", "1").setMessageId("1").setTimeToLive(0L);
        request.serializeValue();
        this.handleRequest((BufferWriter)request);
        ((LogStreamWriter)Mockito.verify((Object)logWriter)).tryWrite((LogAppendEntry)Mockito.any());
    }

    @Test
    public void shouldReturnPartitionLeaderMismatchWhenWriterClosed() {
        LogStreamWriter logWriter = (LogStreamWriter)Mockito.mock(LogStreamWriter.class);
        Mockito.when((Object)logWriter.canWriteEvents(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn((Object)true);
        Mockito.when((Object)logWriter.tryWrite((LogAppendEntry)ArgumentMatchers.any(LogAppendEntry.class))).thenReturn((Object)Either.left((Object)LogStreamWriter.WriteFailure.CLOSED));
        this.handler.addPartition(0, logWriter, (RequestLimiter)new NoopRequestLimiter());
        this.scheduler.workUntilDone();
        BrokerPublishMessageRequest request = new BrokerPublishMessageRequest("test", "1").setMessageId("1").setTimeToLive(0L);
        request.serializeValue();
        CompletableFuture<Either<ErrorResponse, ExecuteCommandResponse>> responseFuture = this.handleRequest((BufferWriter)request);
        ((ObjectAssert)Assertions.assertThat(responseFuture).succeedsWithin(Duration.ofMinutes(1L)).matches(Either::isLeft)).extracting(Either::getLeft).extracting(ErrorResponse::getErrorCode).isEqualTo((Object)ErrorCode.PARTITION_LEADER_MISMATCH);
    }

    @Test
    public void shouldRejectRequestIfTooLarge() {
        Mockito.when((Object)this.logStreamWriter.canWriteEvents(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn((Object)false);
        BrokerPublishMessageRequest request = new BrokerPublishMessageRequest("test", "1").setMessageId("1").setTimeToLive(0L);
        request.serializeValue();
        CompletableFuture<Either<ErrorResponse, ExecuteCommandResponse>> responseFuture = this.handleRequest((BufferWriter)request);
        ((ObjectAssert)Assertions.assertThat(responseFuture).succeedsWithin(Duration.ofMinutes(1L)).matches(Either::isLeft)).extracting(Either::getLeft).extracting(new Function[]{ErrorResponse::getErrorCode, e -> BufferUtil.bufferAsString((DirectBuffer)e.getErrorData())}).containsExactly(new Object[]{ErrorCode.MALFORMED_REQUEST, "Request size is above configured maxMessageSize."});
    }

    private CompletableFuture<Either<ErrorResponse, ExecuteCommandResponse>> handleRequest(BufferWriter request) {
        CompletableFuture<Either<ErrorResponse, ExecuteCommandResponse>> future = new CompletableFuture<Either<ErrorResponse, ExecuteCommandResponse>>();
        ServerOutput serverOutput = this.createServerOutput(future);
        UnsafeBuffer requestBuffer = new UnsafeBuffer(new byte[request.getLength()]);
        request.write((MutableDirectBuffer)requestBuffer, 0);
        this.handler.onRequest(serverOutput, 0, 0L, (DirectBuffer)requestBuffer, 0, request.getLength());
        this.scheduler.workUntilDone();
        return future;
    }

    private ServerOutput createServerOutput(CompletableFuture<Either<ErrorResponse, ExecuteCommandResponse>> future) {
        return serverResponse -> {
            ExpandableArrayBuffer buffer = new ExpandableArrayBuffer();
            serverResponse.write((MutableDirectBuffer)buffer, 0);
            ErrorResponse error = new ErrorResponse();
            if (error.tryWrap((DirectBuffer)buffer)) {
                error.wrap((DirectBuffer)buffer, 0, serverResponse.getLength());
                future.complete(Either.left((Object)error));
                return;
            }
            ExecuteCommandResponse response = new ExecuteCommandResponse();
            try {
                response.wrap((DirectBuffer)buffer, 0, serverResponse.getLength());
                future.complete(Either.right((Object)response));
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        };
    }
}

