/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.commandapi;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.system.configuration.QueryApiCfg;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.transport.backpressure.PartitionAwareRequestLimiter;
import io.camunda.zeebe.broker.transport.backpressure.RequestLimiter;
import io.camunda.zeebe.broker.transport.commandapi.CommandApiServiceImpl;
import io.camunda.zeebe.broker.transport.commandapi.CommandApiServiceTransitionStep;
import io.camunda.zeebe.engine.state.QueryService;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamWriter;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.scheduler.testing.ControlledActorSchedulerExtension;
import io.camunda.zeebe.test.util.junit.RegressionTest;
import io.camunda.zeebe.transport.RequestHandler;
import io.camunda.zeebe.transport.RequestType;
import io.camunda.zeebe.transport.ServerTransport;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class CommandApiServiceImplTest {
    @Mock
    private ServerTransport serverTransport;
    @Mock
    private QueryApiCfg queryApi;
    private CommandApiServiceImpl commandApiService;
    @Mock(strictness=Mock.Strictness.LENIENT)
    private PartitionTransitionContext transitionContext;
    @Mock(strictness=Mock.Strictness.LENIENT)
    private LogStream logStream;
    @RegisterExtension
    private final ControlledActorSchedulerExtension scheduler = new ControlledActorSchedulerExtension();

    @BeforeEach
    public void setup() {
        ConcurrencyControl cc = (ConcurrencyControl)Mockito.mock(ConcurrencyControl.class, (MockSettings)Mockito.withSettings().strictness(Strictness.LENIENT));
        Mockito.when((Object)cc.createCompletedFuture()).thenReturn((Object)CompletableActorFuture.completed(null));
        RequestLimiter requestLimiter = (RequestLimiter)Mockito.mock((Object[])new RequestLimiter[0]);
        PartitionAwareRequestLimiter limiter = (PartitionAwareRequestLimiter)Mockito.mock((MockSettings)Mockito.withSettings().strictness(Strictness.LENIENT), (Object[])new PartitionAwareRequestLimiter[0]);
        Mockito.when((Object)limiter.getLimiter(ArgumentMatchers.anyInt())).thenReturn((Object)requestLimiter);
        this.commandApiService = new CommandApiServiceImpl(this.serverTransport, limiter, (ActorSchedulingService)this.scheduler.getActorScheduler(), this.queryApi, (MeterRegistry)new SimpleMeterRegistry());
        Mockito.when((Object)this.transitionContext.getCommandApiService()).thenReturn((Object)this.commandApiService);
        Mockito.when((Object)this.transitionContext.getConcurrencyControl()).thenReturn((Object)cc);
        this.scheduler.submitActor((Actor)this.commandApiService);
        this.scheduler.workUntilDone();
    }

    @ParameterizedTest
    @EnumSource(value=RaftServer.Role.class, names={"FOLLOWER", "CANDIDATE", "INACTIVE"})
    public void subscribesWhenBecomingLeader(RaftServer.Role nonLeaderRole) {
        Mockito.when((Object)this.transitionContext.getPartitionId()).thenReturn((Object)1);
        Mockito.when((Object)this.logStream.newLogStreamWriter()).thenReturn((Object)CompletableActorFuture.completed((Object)((LogStreamWriter)Mockito.mock((Object[])new LogStreamWriter[0]))));
        Mockito.when((Object)this.transitionContext.getLogStream()).thenReturn((Object)this.logStream);
        Mockito.when((Object)this.transitionContext.getQueryService()).thenReturn((Object)((QueryService)Mockito.mock((Object[])new QueryService[0])));
        CommandApiServiceTransitionStep transitionStep = new CommandApiServiceTransitionStep();
        ActorFuture prepareFuture = transitionStep.prepareTransition(this.transitionContext, 1L, RaftServer.Role.LEADER);
        this.scheduler.workUntilDone();
        prepareFuture.join();
        ActorFuture transitionFuture = transitionStep.transitionTo(this.transitionContext, 1L, RaftServer.Role.LEADER);
        this.scheduler.workUntilDone();
        transitionFuture.join();
        ((LogStream)Mockito.verify((Object)this.logStream, (VerificationMode)Mockito.times((int)1))).newLogStreamWriter();
        ((ServerTransport)Mockito.verify((Object)this.serverTransport, (VerificationMode)Mockito.times((int)1))).subscribe(ArgumentMatchers.eq((int)1), (RequestType)ArgumentMatchers.eq((Object)RequestType.QUERY), (RequestHandler)ArgumentMatchers.any());
        ((ServerTransport)Mockito.verify((Object)this.serverTransport, (VerificationMode)Mockito.times((int)1))).subscribe(ArgumentMatchers.eq((int)1), (RequestType)ArgumentMatchers.eq((Object)RequestType.COMMAND), (RequestHandler)ArgumentMatchers.any());
        ActorFuture prepareFollowerFuture = transitionStep.prepareTransition(this.transitionContext, 2L, nonLeaderRole);
        this.scheduler.workUntilDone();
        prepareFollowerFuture.join();
        ((ServerTransport)Mockito.verify((Object)this.serverTransport, (VerificationMode)Mockito.times((int)1))).unsubscribe(ArgumentMatchers.eq((int)1), (RequestType)ArgumentMatchers.eq((Object)RequestType.QUERY));
        ((ServerTransport)Mockito.verify((Object)this.serverTransport, (VerificationMode)Mockito.times((int)1))).unsubscribe(ArgumentMatchers.eq((int)1), (RequestType)ArgumentMatchers.eq((Object)RequestType.COMMAND));
        Mockito.clearInvocations((Object[])new ServerTransport[]{this.serverTransport});
        ActorFuture transitionFollowerFuture = transitionStep.transitionTo(this.transitionContext, 2L, nonLeaderRole);
        this.scheduler.workUntilDone();
        transitionFollowerFuture.join();
        ((ServerTransport)Mockito.verify((Object)this.serverTransport, (VerificationMode)Mockito.never())).unsubscribe(ArgumentMatchers.eq((int)1), (RequestType)ArgumentMatchers.eq((Object)RequestType.QUERY));
        ((ServerTransport)Mockito.verify((Object)this.serverTransport, (VerificationMode)Mockito.never())).unsubscribe(ArgumentMatchers.eq((int)1), (RequestType)ArgumentMatchers.eq((Object)RequestType.COMMAND));
    }

    @RegressionTest(value="https://github.com/camunda/camunda/issues/25897")
    @Timeout(value=10L)
    public void shouldUnsubscribeTwiceWhenTransitioningFromFollowerToInactive() {
        Mockito.when((Object)this.transitionContext.getPartitionId()).thenReturn((Object)1);
        CommandApiServiceTransitionStep transitionStep = new CommandApiServiceTransitionStep();
        ActorFuture prepareFollowerFuture = transitionStep.prepareTransition(this.transitionContext, 1L, RaftServer.Role.FOLLOWER);
        this.scheduler.workUntilDone();
        prepareFollowerFuture.join();
        ActorFuture transitionFollowerFuture = transitionStep.transitionTo(this.transitionContext, 1L, RaftServer.Role.FOLLOWER);
        this.scheduler.workUntilDone();
        transitionFollowerFuture.join();
        ((ServerTransport)Mockito.verify((Object)this.serverTransport, (VerificationMode)Mockito.times((int)1))).unsubscribe(ArgumentMatchers.eq((int)1), (RequestType)ArgumentMatchers.eq((Object)RequestType.QUERY));
        ((ServerTransport)Mockito.verify((Object)this.serverTransport, (VerificationMode)Mockito.times((int)1))).unsubscribe(ArgumentMatchers.eq((int)1), (RequestType)ArgumentMatchers.eq((Object)RequestType.COMMAND));
        Mockito.clearInvocations((Object[])new ServerTransport[]{this.serverTransport});
        ActorFuture unregisterFuture = transitionStep.prepareTransition(this.transitionContext, 2L, RaftServer.Role.INACTIVE);
        this.scheduler.workUntilDone();
        unregisterFuture.join();
        ActorFuture transitionInactiveFuture = transitionStep.transitionTo(this.transitionContext, 2L, RaftServer.Role.INACTIVE);
        this.scheduler.workUntilDone();
        transitionInactiveFuture.join();
        ((ServerTransport)Mockito.verify((Object)this.serverTransport, (VerificationMode)Mockito.times((int)1))).unsubscribe(ArgumentMatchers.eq((int)1), (RequestType)ArgumentMatchers.eq((Object)RequestType.QUERY));
        ((ServerTransport)Mockito.verify((Object)this.serverTransport, (VerificationMode)Mockito.times((int)1))).unsubscribe(ArgumentMatchers.eq((int)1), (RequestType)ArgumentMatchers.eq((Object)RequestType.COMMAND));
    }

    @RegressionTest(value="https://github.com/camunda/camunda/issues/25897")
    @Timeout(value=10L)
    public void shouldUnsubscribeOnActorClosing() {
        Mockito.when((Object)this.logStream.newLogStreamWriter()).thenReturn((Object)CompletableActorFuture.completed((Object)((LogStreamWriter)Mockito.mock((Object[])new LogStreamWriter[0]))));
        Mockito.when((Object)this.transitionContext.getQueryService()).thenReturn((Object)((QueryService)Mockito.mock((Object[])new QueryService[0])));
        ActorFuture registerFuture = this.commandApiService.registerHandlers(1, this.logStream, this.transitionContext.getQueryService());
        this.scheduler.workUntilDone();
        ((ServerTransport)Mockito.verify((Object)this.serverTransport)).subscribe(ArgumentMatchers.eq((int)1), (RequestType)ArgumentMatchers.eq((Object)RequestType.QUERY), (RequestHandler)ArgumentMatchers.any());
        registerFuture.join();
        ((ServerTransport)Mockito.verify((Object)this.serverTransport)).subscribe(ArgumentMatchers.eq((int)1), (RequestType)ArgumentMatchers.eq((Object)RequestType.COMMAND), (RequestHandler)ArgumentMatchers.any());
        ActorFuture closeFuture = this.commandApiService.closeAsync();
        this.scheduler.workUntilDone();
        closeFuture.join();
        ((ServerTransport)Mockito.verify((Object)this.serverTransport)).unsubscribe(ArgumentMatchers.eq((int)1), (RequestType)ArgumentMatchers.eq((Object)RequestType.QUERY));
        ((ServerTransport)Mockito.verify((Object)this.serverTransport)).unsubscribe(ArgumentMatchers.eq((int)1), (RequestType)ArgumentMatchers.eq((Object)RequestType.COMMAND));
    }
}

