/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.commandapi;

import io.camunda.zeebe.broker.transport.commandapi.CommandResponseWriterImpl;
import io.camunda.zeebe.protocol.record.ExecuteCommandResponseDecoder;
import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.util.StringUtil;
import io.camunda.zeebe.util.VarDataUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import io.camunda.zeebe.util.buffer.DirectBufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public final class CommandResponseWriterImplTest {
    private static final int PARTITION_ID = 1;
    private static final long KEY = 2L;
    private static final byte[] EVENT = StringUtil.getBytes((String)"state");
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final ExecuteCommandResponseDecoder responseDecoder = new ExecuteCommandResponseDecoder();
    private CommandResponseWriterImpl responseWriter;
    private DirectBufferWriter eventWriter;

    @Before
    public void setup() {
        this.eventWriter = new DirectBufferWriter();
    }

    @Test
    public void shouldWriteResponse() {
        this.responseWriter = new CommandResponseWriterImpl(null);
        this.eventWriter.wrap((DirectBuffer)new UnsafeBuffer(EVENT), 0, EVENT.length);
        this.responseWriter.partitionId(1).key(2L).recordType(RecordType.EVENT).valueType(ValueType.JOB).intent((Intent)JobIntent.CREATED).valueWriter((BufferWriter)this.eventWriter);
        UnsafeBuffer buf = new UnsafeBuffer(new byte[this.responseWriter.getLength()]);
        this.responseWriter.write((MutableDirectBuffer)buf, 0);
        int offset = 0;
        this.messageHeaderDecoder.wrap((DirectBuffer)buf, offset);
        Assertions.assertThat((int)this.messageHeaderDecoder.blockLength()).isEqualTo(this.responseDecoder.sbeBlockLength());
        Assertions.assertThat((int)this.messageHeaderDecoder.templateId()).isEqualTo(this.responseDecoder.sbeTemplateId());
        Assertions.assertThat((int)this.messageHeaderDecoder.schemaId()).isEqualTo(this.responseDecoder.sbeSchemaId());
        Assertions.assertThat((int)this.messageHeaderDecoder.version()).isEqualTo(this.responseDecoder.sbeSchemaVersion());
        this.responseDecoder.wrap((DirectBuffer)buf, offset += this.messageHeaderDecoder.encodedLength(), this.responseDecoder.sbeBlockLength(), this.responseDecoder.sbeSchemaVersion());
        Assertions.assertThat((int)this.responseDecoder.partitionId()).isEqualTo(1);
        Assertions.assertThat((long)this.responseDecoder.key()).isEqualTo(2L);
        Assertions.assertThat((Comparable)this.responseDecoder.recordType()).isEqualTo((Object)RecordType.EVENT);
        Assertions.assertThat((Comparable)this.responseDecoder.valueType()).isEqualTo((Object)ValueType.JOB);
        Assertions.assertThat((short)this.responseDecoder.intent()).isEqualTo(JobIntent.CREATED.value());
        Assertions.assertThat((int)this.responseDecoder.valueLength()).isEqualTo(EVENT.length);
        byte[] event = VarDataUtil.readBytes((arg_0, arg_1, arg_2) -> ((ExecuteCommandResponseDecoder)this.responseDecoder).getValue(arg_0, arg_1, arg_2), () -> ((ExecuteCommandResponseDecoder)this.responseDecoder).valueLength());
        Assertions.assertThat((byte[])event).isEqualTo((Object)EVENT);
    }
}

