/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.commandapi;

import io.camunda.zeebe.broker.transport.ErrorResponseWriter;
import io.camunda.zeebe.protocol.record.ErrorCode;
import io.camunda.zeebe.protocol.record.ErrorResponseDecoder;
import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public final class ErrorResponseWriterTest {
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final ErrorResponseDecoder responseDecoder = new ErrorResponseDecoder();
    private ErrorResponseWriter responseWriter;

    @Before
    public void setup() {
        this.responseWriter = new ErrorResponseWriter(null);
    }

    @Test
    public void shouldWriteResponse() {
        this.responseWriter.errorCode(ErrorCode.PARTITION_LEADER_MISMATCH).errorMessage("error message");
        UnsafeBuffer buf = new UnsafeBuffer(new byte[this.responseWriter.getLength()]);
        this.responseWriter.write((MutableDirectBuffer)buf, 0);
        int offset = 0;
        this.messageHeaderDecoder.wrap((DirectBuffer)buf, offset);
        Assertions.assertThat((int)this.messageHeaderDecoder.schemaId()).isEqualTo(this.responseDecoder.sbeSchemaId());
        Assertions.assertThat((int)this.messageHeaderDecoder.version()).isEqualTo(this.responseDecoder.sbeSchemaVersion());
        Assertions.assertThat((int)this.messageHeaderDecoder.templateId()).isEqualTo(this.responseDecoder.sbeTemplateId());
        Assertions.assertThat((int)this.messageHeaderDecoder.blockLength()).isEqualTo(this.responseDecoder.sbeBlockLength());
        this.responseDecoder.wrap((DirectBuffer)buf, offset += this.messageHeaderDecoder.encodedLength(), this.responseDecoder.sbeBlockLength(), this.responseDecoder.sbeSchemaVersion());
        Assertions.assertThat((Comparable)this.responseDecoder.errorCode()).isEqualTo((Object)ErrorCode.PARTITION_LEADER_MISMATCH);
        Assertions.assertThat((String)this.responseDecoder.errorData()).isEqualTo("error message");
    }
}

