/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.partitionapi;

import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.camunda.zeebe.broker.transport.partitionapi.InterPartitionCommandReceiverImpl;
import io.camunda.zeebe.broker.transport.partitionapi.InterPartitionCommandSenderImpl;
import io.camunda.zeebe.logstreams.log.LogAppendEntry;
import io.camunda.zeebe.logstreams.log.LogStreamWriter;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.record.value.management.CheckpointRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.management.CheckpointIntent;
import io.camunda.zeebe.util.Either;
import java.util.function.Function;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
final class InterPartitionCommandCheckpointTest {
    private final ClusterCommunicationService communicationService;
    private final LogStreamWriter logStreamWriter;
    private final InterPartitionCommandSenderImpl sender;
    private final InterPartitionCommandReceiverImpl receiver;

    InterPartitionCommandCheckpointTest(@Mock ClusterCommunicationService communicationService, @Mock(answer=Answers.RETURNS_SELF) LogStreamWriter logStreamWriter) {
        this.communicationService = communicationService;
        this.logStreamWriter = logStreamWriter;
        this.sender = new InterPartitionCommandSenderImpl(communicationService);
        this.sender.setCurrentLeader(1, 2);
        this.receiver = new InterPartitionCommandReceiverImpl(logStreamWriter);
    }

    @Test
    void shouldHandleMissingCheckpoints() {
        Mockito.when((Object)this.logStreamWriter.tryWrite((LogAppendEntry)Mockito.any())).thenReturn((Object)Either.right((Object)1L));
        this.sendAndReceive(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.CREATE);
        ((LogStreamWriter)Mockito.verify((Object)this.logStreamWriter, (VerificationMode)Mockito.times((int)1))).tryWrite(this.matchesMetadata(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.CREATE));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.logStreamWriter});
    }

    @Test
    void shouldCreateFirstCheckpoint() {
        Mockito.when((Object)this.logStreamWriter.tryWrite((LogAppendEntry)Mockito.any())).thenReturn((Object)Either.right((Object)1L));
        this.sender.setCheckpointId(1L);
        this.sendAndReceive(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.CREATE);
        InOrder io = Mockito.inOrder((Object[])new Object[]{this.logStreamWriter});
        ((LogStreamWriter)io.verify((Object)this.logStreamWriter, Mockito.times((int)1))).tryWrite(this.matchesCheckpoint(1L));
        ((LogStreamWriter)io.verify((Object)this.logStreamWriter, Mockito.times((int)1))).tryWrite(this.matchesMetadata(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.CREATE));
        io.verifyNoMoreInteractions();
    }

    @Test
    void shouldUpdateExistingCheckpoint() {
        Mockito.when((Object)this.logStreamWriter.tryWrite((LogAppendEntry)Mockito.any())).thenReturn((Object)Either.right((Object)1L));
        this.receiver.setCheckpointId(5L);
        this.sender.setCheckpointId(17L);
        this.sendAndReceive(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.CREATE);
        InOrder io = Mockito.inOrder((Object[])new Object[]{this.logStreamWriter});
        ((LogStreamWriter)io.verify((Object)this.logStreamWriter)).tryWrite(this.matchesCheckpoint(17L));
        ((LogStreamWriter)io.verify((Object)this.logStreamWriter)).tryWrite(this.matchesMetadata(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.CREATE));
    }

    @Test
    void shouldNotRecreateExistingCheckpoint() {
        Mockito.when((Object)this.logStreamWriter.tryWrite((LogAppendEntry)Mockito.any())).thenReturn((Object)Either.right((Object)1L));
        this.receiver.setCheckpointId(5L);
        this.sender.setCheckpointId(5L);
        this.sendAndReceive(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.CREATE);
        ((LogStreamWriter)Mockito.verify((Object)this.logStreamWriter)).tryWrite(this.matchesMetadata(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.CREATE));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.logStreamWriter});
    }

    @Test
    void shouldNotOverwriteNewerCheckpoint() {
        Mockito.when((Object)this.logStreamWriter.tryWrite((LogAppendEntry)Mockito.any())).thenReturn((Object)Either.right((Object)1L));
        this.receiver.setCheckpointId(6L);
        this.sender.setCheckpointId(5L);
        this.sendAndReceive(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.CREATE);
        ((LogStreamWriter)Mockito.verify((Object)this.logStreamWriter)).tryWrite(this.matchesMetadata(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.CREATE));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.logStreamWriter});
    }

    @Test
    void shouldNotWriteCommandIfCheckpointCreateFailed() {
        Mockito.when((Object)this.logStreamWriter.tryWrite((LogAppendEntry)Mockito.any())).thenReturn((Object)Either.left((Object)LogStreamWriter.WriteFailure.FULL), (Object[])new Either[]{Either.right((Object)1L)});
        this.receiver.setCheckpointId(5L);
        this.sender.setCheckpointId(17L);
        this.sendAndReceive(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.CREATE);
        ((LogStreamWriter)Mockito.verify((Object)this.logStreamWriter)).tryWrite(this.matchesMetadata(ValueType.CHECKPOINT, (Intent)CheckpointIntent.CREATE));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.logStreamWriter});
    }

    @Test
    void shouldNotWriteCommandIfNoDiskAvailable() {
        this.receiver.setDiskSpaceAvailable(false);
        this.receiver.setCheckpointId(5L);
        this.sender.setCheckpointId(17L);
        this.sendAndReceive(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.CREATE);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.logStreamWriter});
    }

    private LogAppendEntry matchesMetadata(ValueType valueType, Intent intent) {
        return (LogAppendEntry)Mockito.argThat(entry -> this.matchesMetadata((LogAppendEntry)entry, valueType, intent));
    }

    private boolean matchesMetadata(LogAppendEntry entry, ValueType valueType, Intent intent) {
        RecordMetadata metadata = entry.recordMetadata();
        return metadata.getValueType() == valueType && metadata.getIntent() == intent;
    }

    private LogAppendEntry matchesCheckpoint(long checkpointId) {
        return (LogAppendEntry)Mockito.argThat(entry -> {
            CheckpointRecord checkpoint;
            UnifiedRecordValue patt0$temp;
            return this.matchesMetadata((LogAppendEntry)entry, ValueType.CHECKPOINT, (Intent)CheckpointIntent.CREATE) && (patt0$temp = entry.recordValue()) instanceof CheckpointRecord && (checkpoint = (CheckpointRecord)patt0$temp).getCheckpointId() == checkpointId;
        });
    }

    private void sendAndReceive(ValueType valueType, Intent intent) {
        this.sender.sendCommand(1, valueType, intent, (UnifiedRecordValue)new JobRecord());
        ArgumentCaptor messageCaptor = ArgumentCaptor.forClass(byte[].class);
        ((ClusterCommunicationService)Mockito.verify((Object)this.communicationService)).unicast((String)ArgumentMatchers.eq((Object)"inter-partition-1"), (Object)((byte[])messageCaptor.capture()), (Function)ArgumentMatchers.any(), (MemberId)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
        this.receiver.handleMessage(new MemberId("0"), (byte[])messageCaptor.getValue());
    }
}

