/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.partitionapi;

import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.camunda.zeebe.broker.transport.partitionapi.InterPartitionCommandReceiverImpl;
import io.camunda.zeebe.broker.transport.partitionapi.InterPartitionCommandSenderImpl;
import io.camunda.zeebe.logstreams.log.LogAppendEntry;
import io.camunda.zeebe.logstreams.log.LogStreamWriter;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.util.Either;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

@Execution(value=ExecutionMode.CONCURRENT)
final class InterPartitionCommandReceiverTest {
    InterPartitionCommandReceiverTest() {
    }

    @Test
    void shouldWriteSentCommandToLogStream() {
        boolean receiverBrokerId = true;
        int receiverPartitionId = 3;
        byte[] sentMessage = this.sendCommand(1, 3, ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.CORRELATE, (UnifiedRecordValue)new MessageSubscriptionRecord().setProcessInstanceKey(1L).setElementInstanceKey(1L));
        LogStreamWriter logStreamWriter = InterPartitionCommandReceiverTest.getLogStreamWriter();
        InterPartitionCommandReceiverImpl receiver = new InterPartitionCommandReceiverImpl(logStreamWriter);
        receiver.handleMessage(new MemberId("0"), sentMessage);
        ((LogStreamWriter)Mockito.verify((Object)logStreamWriter)).tryWrite((LogAppendEntry)Mockito.any());
    }

    private static LogStreamWriter getLogStreamWriter() {
        LogStreamWriter logStreamWriter = (LogStreamWriter)Mockito.mock(LogStreamWriter.class, (MockSettings)Mockito.withSettings().defaultAnswer((Answer)Answers.RETURNS_SELF));
        Mockito.when((Object)logStreamWriter.tryWrite((LogAppendEntry)ArgumentMatchers.any(LogAppendEntry.class))).thenReturn((Object)Either.right((Object)1L));
        return logStreamWriter;
    }

    @Test
    void shouldNotWriteIfNoDiskSpaceAvailable() {
        int receiverBrokerId = 3;
        int receiverPartitionId = 5;
        byte[] sentMessage = this.sendCommand(3, 5, ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.CORRELATE, (UnifiedRecordValue)new MessageSubscriptionRecord().setProcessInstanceKey(1L).setElementInstanceKey(1L));
        LogStreamWriter logStreamWriter = InterPartitionCommandReceiverTest.getLogStreamWriter();
        InterPartitionCommandReceiverImpl receiver = new InterPartitionCommandReceiverImpl(logStreamWriter);
        receiver.setDiskSpaceAvailable(false);
        receiver.handleMessage(new MemberId("0"), sentMessage);
        Mockito.verifyNoInteractions((Object[])new Object[]{logStreamWriter});
    }

    @Test
    void writtenMetadataShouldBeCorrect() {
        boolean receiverBrokerId = true;
        int receiverPartitionId = 5;
        ValueType valueType = ValueType.MESSAGE_SUBSCRIPTION;
        MessageSubscriptionIntent intent = MessageSubscriptionIntent.CORRELATE;
        byte[] sentMessage = this.sendCommand(1, 5, valueType, (Intent)intent, (UnifiedRecordValue)new MessageSubscriptionRecord().setProcessInstanceKey(1L).setElementInstanceKey(1L));
        LogStreamWriter logStreamWriter = InterPartitionCommandReceiverTest.getLogStreamWriter();
        InterPartitionCommandReceiverImpl receiver = new InterPartitionCommandReceiverImpl(logStreamWriter);
        receiver.handleMessage(new MemberId("0"), sentMessage);
        ArgumentCaptor entryCaptor = ArgumentCaptor.forClass(LogAppendEntry.class);
        ((LogStreamWriter)Mockito.verify((Object)logStreamWriter)).tryWrite((LogAppendEntry)entryCaptor.capture());
        RecordMetadata metadataWriter = ((LogAppendEntry)entryCaptor.getValue()).recordMetadata();
        ExpandableArrayBuffer metadataBuffer = new ExpandableArrayBuffer();
        RecordMetadata metadata = new RecordMetadata();
        metadataWriter.write((MutableDirectBuffer)metadataBuffer, 0);
        metadata.wrap((DirectBuffer)metadataBuffer, 0, metadataWriter.getLength());
        Assertions.assertThat((Comparable)metadata.getRecordType()).isEqualTo((Object)RecordType.COMMAND);
        Assertions.assertThat((Comparable)metadata.getValueType()).isEqualTo((Object)valueType);
        Assertions.assertThat((Object)metadata.getIntent()).isEqualTo((Object)intent);
    }

    @Test
    void shouldWriteGivenCommand() {
        int receiverBrokerId = 3;
        int receiverPartitionId = 5;
        MessageSubscriptionRecord recordValue = new MessageSubscriptionRecord().setProcessInstanceKey(1L).setElementInstanceKey(1L);
        byte[] sentMessage = this.sendCommand(3, 5, ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.CORRELATE, (UnifiedRecordValue)recordValue);
        LogStreamWriter logStreamWriter = InterPartitionCommandReceiverTest.getLogStreamWriter();
        InterPartitionCommandReceiverImpl receiver = new InterPartitionCommandReceiverImpl(logStreamWriter);
        receiver.handleMessage(new MemberId("0"), sentMessage);
        ArgumentCaptor entryCaptor = ArgumentCaptor.forClass(LogAppendEntry.class);
        ((LogStreamWriter)Mockito.verify((Object)logStreamWriter)).tryWrite((LogAppendEntry)entryCaptor.capture());
        UnifiedRecordValue valueWriter = ((LogAppendEntry)entryCaptor.getValue()).recordValue();
        Assertions.assertThat((Object)valueWriter).isEqualTo((Object)recordValue);
    }

    @Test
    void shouldWriteCommandWithRecordKey() {
        int receiverBrokerId = 3;
        int receiverPartitionId = 5;
        long recordKey = 10L;
        byte[] sentMessage = this.sendCommand(3, 5, ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.CORRELATE, 10L, (UnifiedRecordValue)new MessageSubscriptionRecord().setProcessInstanceKey(1L).setElementInstanceKey(1L));
        LogStreamWriter logStreamWriter = InterPartitionCommandReceiverTest.getLogStreamWriter();
        InterPartitionCommandReceiverImpl receiver = new InterPartitionCommandReceiverImpl(logStreamWriter);
        ArgumentCaptor entryCaptor = ArgumentCaptor.forClass(LogAppendEntry.class);
        receiver.handleMessage(new MemberId("0"), sentMessage);
        ((LogStreamWriter)Mockito.verify((Object)logStreamWriter)).tryWrite((LogAppendEntry)entryCaptor.capture());
        Assertions.assertThat((long)((LogAppendEntry)entryCaptor.getValue()).key()).isEqualTo(10L);
    }

    @Test
    void shouldWriteCommandWithoutKey() {
        int receiverBrokerId = 3;
        int receiverPartitionId = 5;
        byte[] sentMessage = this.sendCommand(3, 5, ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.CORRELATE, (UnifiedRecordValue)new MessageSubscriptionRecord().setProcessInstanceKey(1L).setElementInstanceKey(1L));
        LogStreamWriter logStreamWriter = InterPartitionCommandReceiverTest.getLogStreamWriter();
        InterPartitionCommandReceiverImpl receiver = new InterPartitionCommandReceiverImpl(logStreamWriter);
        ArgumentCaptor entryCaptor = ArgumentCaptor.forClass(LogAppendEntry.class);
        receiver.handleMessage(new MemberId("0"), sentMessage);
        ((LogStreamWriter)Mockito.verify((Object)logStreamWriter)).tryWrite((LogAppendEntry)entryCaptor.capture());
        Assertions.assertThat((long)((LogAppendEntry)entryCaptor.getValue()).key()).isEqualTo(-1L);
    }

    private byte[] sendCommand(Integer receiverBrokerId, Integer receiverPartitionId, ValueType valueType, Intent intent, UnifiedRecordValue recordValue) {
        return this.sendCommand(receiverBrokerId, receiverPartitionId, valueType, intent, null, recordValue);
    }

    private byte[] sendCommand(Integer receiverBrokerId, Integer receiverPartitionId, ValueType valueType, Intent intent, Long recordKey, UnifiedRecordValue recordValue) {
        ClusterCommunicationService communicationService = (ClusterCommunicationService)Mockito.mock(ClusterCommunicationService.class);
        InterPartitionCommandSenderImpl sender = new InterPartitionCommandSenderImpl(communicationService);
        sender.setCurrentLeader(receiverPartitionId.intValue(), receiverBrokerId.intValue());
        sender.sendCommand(receiverPartitionId.intValue(), valueType, intent, recordKey, recordValue);
        ArgumentCaptor messageCaptor = ArgumentCaptor.forClass(byte[].class);
        ((ClusterCommunicationService)Mockito.verify((Object)communicationService)).unicast((String)ArgumentMatchers.eq((Object)("inter-partition-" + receiverPartitionId)), (Object)((byte[])messageCaptor.capture()), (Function)ArgumentMatchers.any(), (MemberId)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
        return (byte[])messageCaptor.getValue();
    }
}

