/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.queryapi;

import io.atomix.cluster.messaging.MessagingConfig;
import io.atomix.cluster.messaging.MessagingService;
import io.atomix.cluster.messaging.impl.NettyMessagingService;
import io.atomix.utils.net.Address;
import io.camunda.zeebe.broker.test.EmbeddedBrokerRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.protocol.impl.encoding.ErrorResponse;
import io.camunda.zeebe.protocol.impl.encoding.ExecuteQueryRequest;
import io.camunda.zeebe.protocol.impl.encoding.ExecuteQueryResponse;
import io.camunda.zeebe.protocol.record.ErrorCode;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.testing.ActorSchedulerRule;
import io.camunda.zeebe.test.broker.protocol.commandapi.CommandApiRule;
import io.camunda.zeebe.test.broker.protocol.commandapi.PartitionTestClient;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.ProcessRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.socket.SocketUtil;
import io.camunda.zeebe.transport.ClientRequest;
import io.camunda.zeebe.transport.ClientTransport;
import io.camunda.zeebe.transport.RequestType;
import io.camunda.zeebe.transport.impl.AtomixClientTransportAdapter;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.time.Duration;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public final class QueryApiIT {
    public final ActorSchedulerRule actor = new ActorSchedulerRule();
    public final EmbeddedBrokerRule broker = new EmbeddedBrokerRule(cfg -> cfg.getExperimental().getQueryApi().setEnabled(true));
    public final CommandApiRule command = new CommandApiRule(this.broker::getAtomixCluster);
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.broker).around((TestRule)this.command).around((TestRule)this.actor);
    private ClientTransport clientTransport;
    private String serverAddress;

    @Before
    public void setup() {
        this.serverAddress = NetUtil.toSocketAddressString((InetSocketAddress)this.broker.getBrokerCfg().getNetwork().getCommandApi().getAddress());
        NettyMessagingService messagingService = new NettyMessagingService(this.broker.getBrokerCfg().getCluster().getClusterName(), Address.from((int)SocketUtil.getNextAddress().getPort()), new MessagingConfig(), this.broker.getMeterRegistry());
        this.clientTransport = new AtomixClientTransportAdapter((MessagingService)messagingService);
        this.actor.submitActor((Actor)((AtomixClientTransportAdapter)this.clientTransport)).join();
        messagingService.start().join();
    }

    @Test
    public void shouldRespondWithErrorWhenDisabled() {
        this.broker.getBrokerCfg().getExperimental().getQueryApi().setEnabled(false);
        DirectBuffer response = (DirectBuffer)this.clientTransport.sendRequest(() -> this.serverAddress, (ClientRequest)new Request().partitionId(1).key(123L).valueType(ValueType.PROCESS), Duration.ofSeconds(10L)).join();
        Assertions.assertThat((Comparable)response).isNotNull();
        ErrorResponse result = new ErrorResponse();
        int length = response.capacity();
        result.wrap(response, 0, length);
        Assertions.assertThat((Comparable)result.getErrorCode()).isEqualTo((Object)ErrorCode.UNSUPPORTED_MESSAGE);
        Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)result.getErrorData())).isEqualTo("Failed to handle query as the query API is disabled; did you configure zeebe.broker.experimental.queryapi.enabled?");
    }

    @Test
    public void shouldRespondWithBpmnProcessIdWhenProcessFound() {
        long key = this.command.partitionClient(1).deployProcess(Bpmn.createExecutableProcess((String)"OneProcessToRuleThemAll").startEvent().endEvent().done()).getProcessDefinitionKey();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ProcessRecordStream)((ProcessRecordStream)((ProcessRecordStream)RecordingExporter.processRecords().withIntent((Intent)ProcessIntent.CREATED)).withRecordKey(key)).limit(1L)).exists()).as("wait until the process definition actually exists in the state", new Object[0])).isTrue();
        DirectBuffer response = (DirectBuffer)this.clientTransport.sendRequest(() -> this.serverAddress, (ClientRequest)new Request().partitionId(1).key(key).valueType(ValueType.PROCESS), Duration.ofSeconds(10L)).join();
        ExecuteQueryResponse result = new ExecuteQueryResponse();
        result.wrap(response, 0, response.capacity());
        Assertions.assertThat((Object)result).extracting(ExecuteQueryResponse::getBpmnProcessId).isEqualTo((Object)"OneProcessToRuleThemAll");
    }

    @Test
    public void shouldRespondWithBpmnProcessIdWhenProcessInstanceFound() {
        PartitionTestClient client = this.command.partitionClient(1);
        client.deploy(Bpmn.createExecutableProcess((String)"OneProcessToRuleThemAll").startEvent().serviceTask("task", b -> b.zeebeJobType("type")).endEvent().done());
        long key = client.createProcessInstance(r -> r.setBpmnProcessId("OneProcessToRuleThemAll")).getProcessInstanceKey();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withProcessInstanceKey(key).filterRootScope().limit(1L)).exists()).as("wait until the element instance actually exists in the state", new Object[0])).isTrue();
        DirectBuffer response = (DirectBuffer)this.clientTransport.sendRequest(() -> this.serverAddress, (ClientRequest)new Request().partitionId(1).key(key).valueType(ValueType.PROCESS_INSTANCE), Duration.ofSeconds(10L)).join();
        ExecuteQueryResponse result = new ExecuteQueryResponse();
        result.wrap(response, 0, response.capacity());
        Assertions.assertThat((Object)result).extracting(ExecuteQueryResponse::getBpmnProcessId).isEqualTo((Object)"OneProcessToRuleThemAll");
    }

    @Test
    public void shouldRespondWithBpmnProcessIdWhenJobFound() {
        long key = this.command.partitionClient(1).createJob("type");
        DirectBuffer response = (DirectBuffer)this.clientTransport.sendRequest(() -> this.serverAddress, (ClientRequest)new Request().partitionId(1).key(key).valueType(ValueType.JOB), Duration.ofSeconds(10L)).join();
        ExecuteQueryResponse result = new ExecuteQueryResponse();
        result.wrap(response, 0, response.capacity());
        Assertions.assertThat((Object)result).extracting(ExecuteQueryResponse::getBpmnProcessId).isEqualTo((Object)"process");
    }

    private static final class Request
    implements ClientRequest {
        private final ExecuteQueryRequest request = new ExecuteQueryRequest();

        private Request() {
        }

        public Request partitionId(int partitionId) {
            this.request.setPartitionId(partitionId);
            return this;
        }

        public Request key(long key) {
            this.request.setKey(key);
            return this;
        }

        public Request valueType(ValueType valueType) {
            this.request.setValueType(valueType);
            return this;
        }

        public int getPartitionId() {
            return this.request.getPartitionId();
        }

        public RequestType getRequestType() {
            return RequestType.QUERY;
        }

        public int getLength() {
            return this.request.getLength();
        }

        public void write(MutableDirectBuffer buffer, int offset) {
            this.request.write(buffer, offset);
        }
    }
}

