/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.bootstrap.ApiMessagingServiceStep;
import io.camunda.zeebe.broker.bootstrap.BrokerAdminServiceStep;
import io.camunda.zeebe.broker.bootstrap.BrokerContext;
import io.camunda.zeebe.broker.bootstrap.BrokerContextImpl;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.bootstrap.BrokerStepMetricDecorator;
import io.camunda.zeebe.broker.bootstrap.ClusterServicesStep;
import io.camunda.zeebe.broker.bootstrap.ClusterTopologyManagerStep;
import io.camunda.zeebe.broker.bootstrap.CommandApiServiceStep;
import io.camunda.zeebe.broker.bootstrap.DiskSpaceUsageMonitorStep;
import io.camunda.zeebe.broker.bootstrap.EmbeddedGatewayServiceStep;
import io.camunda.zeebe.broker.bootstrap.GatewayBrokerTransportStep;
import io.camunda.zeebe.broker.bootstrap.JobStreamServiceStep;
import io.camunda.zeebe.broker.bootstrap.MonitoringServerStep;
import io.camunda.zeebe.broker.bootstrap.PartitionManagerStep;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.monitoring.BrokerStepMetrics;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.startup.StartupProcess;
import io.camunda.zeebe.scheduler.startup.StartupStep;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public final class BrokerStartupProcess {
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private final StartupProcess<BrokerStartupContext> startupProcess;
    private BrokerStartupContext context;
    private final ConcurrencyControl concurrencyControl;

    public BrokerStartupProcess(BrokerStartupContext brokerStartupContext) {
        this.concurrencyControl = brokerStartupContext.getConcurrencyControl();
        this.context = brokerStartupContext;
        BrokerStepMetrics brokerStepMetrics = new BrokerStepMetrics(this.context.getMeterRegistry());
        List<StartupStep<BrokerStartupContext>> undecoratedSteps = this.buildStartupSteps(brokerStartupContext.getBrokerConfiguration());
        List decoratedSteps = undecoratedSteps.stream().map(step -> new BrokerStepMetricDecorator(brokerStepMetrics, (StartupStep<BrokerStartupContext>)step)).collect(Collectors.toList());
        this.startupProcess = new StartupProcess(LOG, decoratedSteps);
    }

    private List<StartupStep<BrokerStartupContext>> buildStartupSteps(BrokerCfg config) {
        ArrayList<StartupStep<BrokerStartupContext>> result = new ArrayList<StartupStep<BrokerStartupContext>>();
        result.add(new ClusterServicesStep());
        result.add(new ClusterTopologyManagerStep());
        result.add(new DiskSpaceUsageMonitorStep());
        result.add(new MonitoringServerStep());
        result.add(new ApiMessagingServiceStep());
        result.add(new GatewayBrokerTransportStep());
        result.add(new CommandApiServiceStep());
        if (config.getGateway().isEnable()) {
            result.add(new EmbeddedGatewayServiceStep());
        }
        result.add(new JobStreamServiceStep());
        result.add(new PartitionManagerStep());
        result.add(new BrokerAdminServiceStep());
        return result;
    }

    public ActorFuture<BrokerContext> start() {
        ActorFuture result = this.concurrencyControl.createFuture();
        ActorFuture startupFuture = this.startupProcess.startup(this.concurrencyControl, (Object)this.context);
        this.concurrencyControl.runOnCompletion(startupFuture, (bsc, error) -> {
            if (error != null) {
                result.completeExceptionally(error);
            } else {
                this.context = bsc;
                result.complete((Object)this.createBrokerContext((BrokerStartupContext)bsc));
            }
        });
        return result;
    }

    public ActorFuture<Void> stop() {
        ActorFuture result = this.concurrencyControl.createFuture();
        ActorFuture shutdownFuture = this.startupProcess.shutdown(this.concurrencyControl, (Object)this.context);
        this.concurrencyControl.runOnCompletion(shutdownFuture, (bsc, error) -> {
            if (error != null) {
                result.completeExceptionally(error);
            } else {
                result.complete(null);
            }
        });
        return result;
    }

    private BrokerContext createBrokerContext(BrokerStartupContext bsc) {
        return new BrokerContextImpl(bsc.getDiskSpaceUsageMonitor(), bsc.getClusterServices(), bsc.getEmbeddedGatewayService(), bsc.getPartitionManager(), bsc.getBrokerAdminService(), bsc.getApiMessagingService());
    }
}

