/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.engine.impl;

import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntConsumer;

public interface ScheduledCommandCacheMetrics {
    public IntConsumer forIntent(Intent var1);

    public static enum SizeKeys implements KeyName
    {
        INTENT{

            public String asString() {
                return "intent";
            }
        };

    }

    public static enum BoundedCacheMetricsDoc implements ExtendedMeterDocumentation
    {
        SIZE{

            public String getName() {
                return "zeebe.stream.processor.scheduled.command.cache.size";
            }

            public Meter.Type getType() {
                return Meter.Type.GAUGE;
            }

            public String getDescription() {
                return "Reports the size of each bounded cache per partition and intent";
            }

            public KeyName[] getKeyNames() {
                return SizeKeys.values();
            }

            public KeyName[] getAdditionalKeyNames() {
                return MicrometerUtil.PartitionKeyNames.values();
            }
        };

    }

    public static class BoundedCommandCacheMetrics
    implements ScheduledCommandCacheMetrics {
        private final Map<Intent, AtomicInteger> sizes = new HashMap<Intent, AtomicInteger>();
        private final MeterRegistry registry;

        public BoundedCommandCacheMetrics(MeterRegistry registry) {
            this.registry = Objects.requireNonNull(registry, "must specify a meter registry");
        }

        @Override
        public IntConsumer forIntent(Intent intent) {
            return this.sizes.computeIfAbsent(intent, this::registerSizeReporter)::set;
        }

        private AtomicInteger registerSizeReporter(Intent intent) {
            String intentLabelValue = intent.getClass().getSimpleName() + "." + intent.name();
            BoundedCacheMetricsDoc meterDoc = BoundedCacheMetricsDoc.SIZE;
            AtomicInteger sizeTracker = new AtomicInteger();
            Gauge.builder((String)meterDoc.getName(), (Object)sizeTracker, AtomicInteger::intValue).description(meterDoc.getDescription()).tag(SizeKeys.INTENT.asString(), intentLabelValue).register(this.registry);
            return sizeTracker;
        }
    }
}

