/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.context;

import io.camunda.zeebe.exporter.api.context.Configuration;
import io.camunda.zeebe.exporter.api.context.Context;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.util.EnsureUtil;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import org.slf4j.Logger;

public final class ExporterContext
implements Context,
AutoCloseable {
    private static final Context.RecordFilter DEFAULT_FILTER = new AcceptAllRecordsFilter();
    private final Logger logger;
    private final Configuration configuration;
    private final int partitionId;
    private final CompositeMeterRegistry meterRegistry;
    private final MeterRegistry underlyingMetricRegistry;
    private Context.RecordFilter filter = DEFAULT_FILTER;

    public ExporterContext(Logger logger, Configuration configuration, int partitionId, MeterRegistry meterRegistry) {
        this.logger = logger;
        this.configuration = configuration;
        this.partitionId = partitionId;
        this.underlyingMetricRegistry = meterRegistry;
        this.meterRegistry = MicrometerUtil.wrap((MeterRegistry)this.underlyingMetricRegistry, (Tags)Tags.concat((Iterable)MicrometerUtil.PartitionKeyNames.tags((int)partitionId), (String[])new String[]{"exporterId", configuration.getId()}));
    }

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public Context.RecordFilter getFilter() {
        return this.filter;
    }

    public void setFilter(Context.RecordFilter filter) {
        EnsureUtil.ensureNotNull((String)"filter", (Object)filter);
        this.filter = filter;
    }

    @Override
    public void close() {
        MicrometerUtil.discard((CompositeMeterRegistry)this.meterRegistry);
    }

    private static final class AcceptAllRecordsFilter
    implements Context.RecordFilter {
        private AcceptAllRecordsFilter() {
        }

        public boolean acceptType(RecordType recordType) {
            return true;
        }

        public boolean acceptValue(ValueType valueType) {
            return true;
        }
    }
}

