/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.metrics;

import io.camunda.zeebe.broker.exporter.metrics.ExecutionLatencyMetricsDoc;
import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutionLatencyMetrics {
    private final AtomicInteger currentCachedInstanceJobsCount = new AtomicInteger();
    private final AtomicInteger currentCacheInstanceProcessInstances = new AtomicInteger();
    private final Timer processInstanceExecutionTime;
    private final Timer jobLifeTime;
    private final Timer jobActivationTime;

    public ExecutionLatencyMetrics() {
        this((MeterRegistry)new SimpleMeterRegistry());
    }

    public ExecutionLatencyMetrics(MeterRegistry meterRegistry) {
        this.processInstanceExecutionTime = MicrometerUtil.buildTimer((ExtendedMeterDocumentation)ExecutionLatencyMetricsDoc.PROCESS_INSTANCE_EXECUTION).register(meterRegistry);
        this.jobLifeTime = MicrometerUtil.buildTimer((ExtendedMeterDocumentation)ExecutionLatencyMetricsDoc.JOB_LIFETIME).register(meterRegistry);
        this.jobActivationTime = MicrometerUtil.buildTimer((ExtendedMeterDocumentation)ExecutionLatencyMetricsDoc.JOB_ACTIVATION_TIME).register(meterRegistry);
        this.registerCacheCount(this.currentCacheInstanceProcessInstances, ExecutionLatencyMetricsDoc.CacheType.PROCESS_INSTANCES, meterRegistry);
        this.registerCacheCount(this.currentCachedInstanceJobsCount, ExecutionLatencyMetricsDoc.CacheType.JOBS, meterRegistry);
    }

    private void registerCacheCount(AtomicInteger state, ExecutionLatencyMetricsDoc.CacheType type, MeterRegistry meterRegistry) {
        Gauge.builder((String)ExecutionLatencyMetricsDoc.CACHED_INSTANCES.getName(), (Object)state, AtomicInteger::get).description(ExecutionLatencyMetricsDoc.CACHED_INSTANCES.getDescription()).tag(ExecutionLatencyMetricsDoc.CacheKeyNames.TYPE.asString(), type.getTagValue()).register(meterRegistry);
    }

    public void observeProcessInstanceExecutionTime(long creationTimeMs, long completionTimeMs) {
        this.processInstanceExecutionTime.record(completionTimeMs - creationTimeMs, TimeUnit.MILLISECONDS);
    }

    public void observeJobLifeTime(long creationTimeMs, long completionTimeMs) {
        this.jobLifeTime.record(completionTimeMs - creationTimeMs, TimeUnit.MILLISECONDS);
    }

    public void observeJobActivationTime(long creationTimeMs, long activationTimeMs) {
        this.jobActivationTime.record(activationTimeMs - creationTimeMs, TimeUnit.MILLISECONDS);
    }

    public void setCurrentJobsCount(int count) {
        this.currentCachedInstanceJobsCount.set(count);
    }

    public void setCurrentProcessInstanceCount(int count) {
        this.currentCacheInstanceProcessInstances.set(count);
    }
}

