/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.metrics;

import io.camunda.zeebe.broker.exporter.stream.ExporterMetricsDoc;
import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;
import java.time.Duration;

public enum ExecutionLatencyMetricsDoc implements ExtendedMeterDocumentation
{
    CACHED_INSTANCES{

        public String getDescription() {
            return "The current cached entities for counting their execution latency. If only short-lived instances are handled this can be seen or observed as the current active instance count.";
        }

        public String getName() {
            return "zeebe.execution.latency.current.cached.instances";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getKeyNames() {
            return CacheKeyNames.values();
        }

        public KeyName[] getAdditionalKeyNames() {
            return KeyName.merge((KeyName[][])new KeyName[][]{MicrometerUtil.PartitionKeyNames.values(), ExporterMetricsDoc.ExporterContainerKeyNames.values()});
        }
    }
    ,
    PROCESS_INSTANCE_EXECUTION{
        private static final Duration[] BUCKETS = new Duration[]{Duration.ofMillis(50L), Duration.ofMillis(75L), Duration.ofMillis(100L), Duration.ofMillis(250L), Duration.ofMillis(500L), Duration.ofMillis(750L), Duration.ofSeconds(1L), Duration.ofMillis(2500L), Duration.ofSeconds(5L), Duration.ofSeconds(10L), Duration.ofSeconds(15L), Duration.ofSeconds(30L), Duration.ofSeconds(45L), Duration.ofMinutes(1L)};

        public String getDescription() {
            return "The execution time of processing a complete process instance";
        }

        public String getName() {
            return "zeebe.process.instance.execution.time";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public Duration[] getTimerSLOs() {
            return BUCKETS;
        }
    }
    ,
    JOB_LIFETIME{
        private static final Duration[] BUCKETS = new Duration[]{Duration.ofMillis(50L), Duration.ofMillis(75L), Duration.ofMillis(100L), Duration.ofMillis(250L), Duration.ofMillis(500L), Duration.ofMillis(750L), Duration.ofSeconds(1L), Duration.ofMillis(2500L), Duration.ofSeconds(5L), Duration.ofSeconds(10L), Duration.ofSeconds(15L), Duration.ofSeconds(30L), Duration.ofSeconds(45L)};

        public String getDescription() {
            return "The lifetime of a job";
        }

        public String getName() {
            return "zeebe.job.life.time";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public Duration[] getTimerSLOs() {
            return BUCKETS;
        }
    }
    ,
    JOB_ACTIVATION_TIME{
        private static final Duration[] BUCKETS = new Duration[]{Duration.ofMillis(50L), Duration.ofMillis(75L), Duration.ofMillis(100L), Duration.ofMillis(250L), Duration.ofMillis(500L), Duration.ofMillis(750L), Duration.ofSeconds(1L), Duration.ofMillis(2500L), Duration.ofSeconds(5L), Duration.ofSeconds(10L), Duration.ofSeconds(15L), Duration.ofSeconds(30L)};

        public String getDescription() {
            return "The time until a job was activated";
        }

        public String getName() {
            return "zeebe.job.activation.time";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public Duration[] getTimerSLOs() {
            return BUCKETS;
        }
    };


    public static enum CacheType {
        JOBS("jobs"),
        PROCESS_INSTANCES("processInstances");

        private final String tagValue;

        private CacheType(String tagValue) {
            this.tagValue = tagValue;
        }

        public String getTagValue() {
            return this.tagValue;
        }
    }

    public static enum CacheKeyNames implements KeyName
    {
        TYPE{

            public String asString() {
                return "type";
            }
        };

    }
}

