/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.stream;

import io.camunda.zeebe.broker.exporter.stream.ExporterMetricsDoc;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.util.collection.Table;
import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public final class ExporterMetrics {
    private static final String LABEL_NAME_EXPORTER = "exporter";
    private static final String LABEL_NAME_ACTION = "action";
    private static final String LABEL_NAME_VALUE_TYPE = "valueType";
    private final Map<String, AtomicLong> lastExportedPositions = new HashMap<String, AtomicLong>();
    private final Map<String, AtomicLong> lastUpdatedExportedPositions = new HashMap<String, AtomicLong>();
    private final Table<ExporterMetricsDoc.ExporterActionKeyNames, ValueType, Counter> exporterEvents = Table.ofEnum(ExporterMetricsDoc.ExporterActionKeyNames.class, ValueType.class, Counter[]::new);
    private final MeterRegistry meterRegistry;

    public ExporterMetrics(MeterRegistry meterRegistry) {
        this.meterRegistry = Objects.requireNonNull(meterRegistry, "must specify a meter registry");
    }

    public void eventExported(ValueType valueType) {
        this.event(ExporterMetricsDoc.ExporterActionKeyNames.EXPORTED, valueType);
    }

    public void eventSkipped(ValueType valueType) {
        this.event(ExporterMetricsDoc.ExporterActionKeyNames.SKIPPED, valueType);
    }

    public void setLastUpdatedExportedPosition(String exporter, long position) {
        this.lastUpdatedExportedPositions.computeIfAbsent(exporter, id -> this.registerPerExporterGauge(ExporterMetricsDoc.LAST_UPDATED_EXPORTED_POSITION, (String)id, position)).set(position);
    }

    public void setLastExportedPosition(String exporter, long position) {
        this.lastExportedPositions.computeIfAbsent(exporter, id -> this.registerPerExporterGauge(ExporterMetricsDoc.LAST_EXPORTED_POSITION, (String)id, position)).set(position);
    }

    private void event(ExporterMetricsDoc.ExporterActionKeyNames action, ValueType valueType) {
        ((Counter)this.exporterEvents.computeIfAbsent((Object)action, (Object)valueType, this::registerExporterEventCounter)).increment();
    }

    private Counter registerExporterEventCounter(ExporterMetricsDoc.ExporterActionKeyNames action, ValueType valueType) {
        ExporterMetricsDoc meterDoc = ExporterMetricsDoc.EXPORTER_EVENTS;
        return Counter.builder((String)meterDoc.getName()).description(meterDoc.getDescription()).tag(LABEL_NAME_ACTION, action.name()).tag(LABEL_NAME_VALUE_TYPE, valueType.name()).register(this.meterRegistry);
    }

    private AtomicLong registerPerExporterGauge(ExtendedMeterDocumentation meterDoc, String exporterId, long initialPosition) {
        AtomicLong position = new AtomicLong(initialPosition);
        Gauge.builder((String)meterDoc.getName(), (Object)position, Number::longValue).tag(LABEL_NAME_EXPORTER, exporterId).description(meterDoc.getDescription()).register(this.meterRegistry);
        return position;
    }
}

