/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.stream;

import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;

public enum ExporterMetricsDoc implements ExtendedMeterDocumentation
{
    LAST_EXPORTED_POSITION{

        public String getName() {
            return "zeebe.exporter.last.exported.position";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public String getDescription() {
            return "The last exported position by exporter and partition";
        }
    }
    ,
    LAST_UPDATED_EXPORTED_POSITION{

        public String getName() {
            return "zeebe.exporter.last.updated.exported.position";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public String getDescription() {
            return "The last exported position which was also updated/committed by the exporter";
        }
    }
    ,
    EXPORTER_STATE{

        public String getName() {
            return "zeebe.exporter.state";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public String getDescription() {
            return "Describes the phase of the exporter, namely if it is exporting (0), paused (1), soft paused (2), or closed (3)";
        }
    }
    ,
    EXPORTING_LATENCY{

        public String getName() {
            return "zeebe.exporting.latency";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public String getDescription() {
            return "Time between a record is written until it is picked up for exporting (in seconds)";
        }
    }
    ,
    EXPORTING_DURATION{

        public String getName() {
            return "zeebe.exporter.exporting.duration";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public String getDescription() {
            return "The time an exporter needs to export certain record (duration in seconds)";
        }
    }
    ,
    EXPORTER_EVENTS{

        public String getName() {
            return "zeebe.exporter.events.total";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public String getDescription() {
            return "Number of events processed by exporter";
        }

        public KeyName[] getKeyNames() {
            return ExporterActionKeyNames.values();
        }
    };


    static enum ExporterActionKeyNames implements KeyName
    {
        SKIPPED{

            public String asString() {
                return "skipped";
            }
        }
        ,
        EXPORTED{

            public String asString() {
                return "exported";
            }
        };

    }

    public static enum ExporterContainerKeyNames implements KeyName
    {
        EXPORTER_ID{

            public String asString() {
                return "exporterId";
            }
        };

    }
}

