/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.stream;

import io.camunda.zeebe.broker.exporter.stream.ExporterStateEntry;
import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.agrona.DirectBuffer;
import org.agrona.collections.LongArrayList;
import org.agrona.concurrent.UnsafeBuffer;

public final class ExportersState {
    public static final long VALUE_NOT_FOUND = -1L;
    private static final UnsafeBuffer METADATA_NOT_FOUND = new UnsafeBuffer();
    private final DbString exporterId = new DbString();
    private final ColumnFamily<DbString, ExporterStateEntry> exporterPositionColumnFamily;

    public ExportersState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.exporterPositionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.EXPORTER, transactionContext, (DbKey)this.exporterId, (DbValue)new ExporterStateEntry());
    }

    public void setPosition(String exporterId, long position) {
        this.setExporterState(exporterId, position, null);
    }

    public void setExporterState(String exporterId, long position, DirectBuffer metadata) {
        this.exporterId.wrapString(exporterId);
        ExporterStateEntry exporterStateEntry = this.findExporterStateEntry(exporterId).orElse(new ExporterStateEntry());
        exporterStateEntry.setPosition(position);
        if (metadata != null) {
            exporterStateEntry.setMetadata(metadata);
        }
        this.exporterPositionColumnFamily.upsert((DbKey)this.exporterId, (DbValue)exporterStateEntry);
    }

    public long getPosition(String exporterId) {
        return this.findExporterStateEntry(exporterId).map(ExporterStateEntry::getPosition).orElse(-1L);
    }

    public DirectBuffer getExporterMetadata(String exporterId) {
        return this.findExporterStateEntry(exporterId).map(ExporterStateEntry::getMetadata).orElse((DirectBuffer)METADATA_NOT_FOUND);
    }

    private Optional<ExporterStateEntry> findExporterStateEntry(String exporterId) {
        this.exporterId.wrapString(exporterId);
        return Optional.ofNullable((ExporterStateEntry)this.exporterPositionColumnFamily.get((DbKey)this.exporterId));
    }

    public void visitExporterState(BiConsumer<String, ExporterStateEntry> consumer) {
        this.exporterPositionColumnFamily.forEach((exporterId, exporterStateEntry) -> consumer.accept(exporterId.toString(), (ExporterStateEntry)((Object)exporterStateEntry)));
    }

    public long getLowestPosition() {
        LongArrayList positions = new LongArrayList();
        this.visitExporterState((exporterId, exporterStateEntry) -> positions.addLong(exporterStateEntry.getPosition()));
        return positions.longStream().min().orElse(-1L);
    }

    public void removeExporterState(String exporterId) {
        this.exporterId.wrapString(exporterId);
        this.exporterPositionColumnFamily.deleteIfExists((DbKey)this.exporterId);
    }

    public boolean hasExporters() {
        return !this.exporterPositionColumnFamily.isEmpty();
    }
}

