/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.jobstream;

import io.camunda.zeebe.broker.jobstream.JobStreamMetricsDoc;
import io.camunda.zeebe.transport.stream.api.RemoteStreamMetrics;
import io.camunda.zeebe.transport.stream.impl.messages.ErrorCode;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class JobStreamMetrics
implements RemoteStreamMetrics {
    private final AtomicInteger streamCount = new AtomicInteger(0);
    private final Map<ErrorCode, Counter> pushTryFailedCount = new EnumMap<ErrorCode, Counter>(ErrorCode.class);
    private final MeterRegistry registry;
    private final Counter pushSuccessCount;
    private final Counter pushFailedCount;

    public JobStreamMetrics(MeterRegistry registry) {
        this.registry = registry;
        this.pushSuccessCount = this.registerCounter(JobStreamMetricsDoc.PUSH_SUCCESS_COUNT, new Tag[0]);
        this.pushFailedCount = this.registerCounter(JobStreamMetricsDoc.PUSH_FAILED_COUNT, new Tag[0]);
        JobStreamMetricsDoc streamCountDoc = JobStreamMetricsDoc.STREAM_COUNT;
        Gauge.builder((String)streamCountDoc.getName(), (Object)this.streamCount, Number::intValue).description(streamCountDoc.getDescription()).register(registry);
    }

    private Counter registerCounter(JobStreamMetricsDoc doc, Tag ... tags) {
        Counter.Builder builder = Counter.builder((String)doc.getName()).description(doc.getDescription());
        for (Tag tag : tags) {
            builder.tag(tag.getKey(), tag.getValue());
        }
        return builder.register(this.registry);
    }

    public void addStream() {
        this.streamCount.incrementAndGet();
    }

    public void removeStream() {
        this.streamCount.decrementAndGet();
    }

    public void pushSucceeded() {
        this.pushSuccessCount.increment();
    }

    public void pushFailed() {
        this.pushFailedCount.increment();
    }

    public void pushTryFailed(ErrorCode code) {
        JobStreamMetricsDoc meterDoc = JobStreamMetricsDoc.PUSH_TRY_FAILED_COUNT;
        this.pushTryFailedCount.computeIfAbsent(code, ignored -> this.registerCounter(meterDoc, Tag.of((String)"code", (String)code.name()))).increment();
    }
}

