/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning;

import io.atomix.cluster.MemberId;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.partition.RaftPartition;
import io.camunda.zeebe.broker.partitioning.startup.PartitionStartupContext;
import io.camunda.zeebe.broker.partitioning.startup.steps.MetricsStep;
import io.camunda.zeebe.broker.partitioning.startup.steps.PartitionDirectoryStep;
import io.camunda.zeebe.broker.partitioning.startup.steps.PartitionRegistrationStep;
import io.camunda.zeebe.broker.partitioning.startup.steps.RaftBootstrapStep;
import io.camunda.zeebe.broker.partitioning.startup.steps.RaftJoinStep;
import io.camunda.zeebe.broker.partitioning.startup.steps.SnapshotStoreStep;
import io.camunda.zeebe.broker.partitioning.startup.steps.ZeebePartitionStep;
import io.camunda.zeebe.broker.system.partitions.ZeebePartition;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.startup.StartupProcess;
import io.camunda.zeebe.util.FileUtil;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Partition {
    private static final Logger LOGGER = LoggerFactory.getLogger(Partition.class);
    private final PartitionStartupContext context;
    private final StartupProcess<PartitionStartupContext> startupProcess;

    private Partition(PartitionStartupContext context, StartupProcess<PartitionStartupContext> startupProcess) {
        this.context = context;
        this.startupProcess = startupProcess;
    }

    static Partition bootstrapping(PartitionStartupContext context) {
        return new Partition(context, (StartupProcess<PartitionStartupContext>)new StartupProcess(LOGGER, List.of(new MetricsStep(), new PartitionDirectoryStep(), new SnapshotStoreStep(), new RaftBootstrapStep(), new ZeebePartitionStep(), new PartitionRegistrationStep())));
    }

    static Partition joining(PartitionStartupContext context) {
        return new Partition(context, (StartupProcess<PartitionStartupContext>)new StartupProcess(List.of(new MetricsStep(), new PartitionDirectoryStep(), new SnapshotStoreStep(), new RaftJoinStep(), new ZeebePartitionStep(), new PartitionRegistrationStep())));
    }

    ActorFuture<Partition> start() {
        ConcurrencyControl concurrencyControl = this.context.concurrencyControl();
        ActorFuture result = concurrencyControl.createFuture();
        concurrencyControl.run(() -> {
            ActorFuture start = this.startupProcess.startup(concurrencyControl, (Object)this.context);
            concurrencyControl.runOnCompletion(start, (ok, error) -> {
                if (error != null) {
                    result.completeExceptionally(error);
                } else {
                    result.complete((Object)this);
                }
            });
        });
        return result;
    }

    ActorFuture<Partition> stop() {
        ConcurrencyControl concurrencyControl = this.context.concurrencyControl();
        ActorFuture result = concurrencyControl.createFuture();
        concurrencyControl.run(() -> {
            ActorFuture start = this.startupProcess.shutdown(concurrencyControl, (Object)this.context);
            concurrencyControl.runOnCompletion(start, (ok, error) -> {
                if (error != null) {
                    result.completeExceptionally(error);
                } else {
                    result.complete((Object)this);
                }
            });
        });
        return result;
    }

    ActorFuture<Partition> leave() {
        ConcurrencyControl concurrencyControl = this.context.concurrencyControl();
        ActorFuture result = concurrencyControl.createFuture();
        concurrencyControl.run(() -> {
            RaftPartition raftPartition = this.raftPartition();
            if (raftPartition == null) {
                result.completeExceptionally((Throwable)this.errorPartitionNotAvailable("leave"));
                return;
            }
            raftPartition.leave().whenComplete((leaveOk, leaveError) -> concurrencyControl.run(() -> this.onPartitionLeaveCompleted((Throwable)leaveError, (ActorFuture<Partition>)result)));
        });
        return result;
    }

    private void onPartitionLeaveCompleted(Throwable leaveError, ActorFuture<Partition> result) {
        if (leaveError != null) {
            result.completeExceptionally(leaveError);
            return;
        }
        ConcurrencyControl concurrencyControl = this.context.concurrencyControl();
        Path partitionDirectory = this.context.partitionDirectory();
        concurrencyControl.runOnCompletion(this.startupProcess.shutdown(concurrencyControl, (Object)this.context), (shutdownOk, shutdownError) -> {
            if (shutdownError != null) {
                result.completeExceptionally(shutdownError);
                return;
            }
            try {
                FileUtil.deleteFolderIfExists((Path)partitionDirectory);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to delete partition directory {} after leaving. Data will remain until manually removed.", (Object)partitionDirectory, (Object)e);
            }
            result.complete((Object)this);
        });
    }

    ActorFuture<Void> reconfigurePriority(int newPriority) {
        ConcurrencyControl concurrencyControl = this.context.concurrencyControl();
        ActorFuture result = concurrencyControl.createFuture();
        concurrencyControl.run(() -> {
            RaftPartition raftPartition = this.raftPartition();
            if (raftPartition == null) {
                result.completeExceptionally((Throwable)this.errorPartitionNotAvailable("reconfigure priority of"));
                return;
            }
            raftPartition.getServer().reconfigurePriority(newPriority).whenComplete((configureOk, configureError) -> {
                if (configureError != null) {
                    result.completeExceptionally(configureError);
                } else {
                    result.complete(null);
                }
            });
        });
        return result;
    }

    ActorFuture<Void> forceReconfigure(Collection<MemberId> members) {
        ConcurrencyControl concurrencyControl = this.context.concurrencyControl();
        ActorFuture result = concurrencyControl.createFuture();
        concurrencyControl.run(() -> {
            RaftPartition raftPartition = this.raftPartition();
            if (raftPartition == null) {
                result.completeExceptionally((Throwable)this.errorPartitionNotAvailable("force reconfigure"));
                return;
            }
            Map<MemberId, RaftMember.Type> membersWithType = members.stream().collect(Collectors.toMap(m -> m, m -> RaftMember.Type.ACTIVE));
            raftPartition.getServer().forceReconfigure(membersWithType).whenComplete((configureOk, configureError) -> {
                if (configureError != null) {
                    result.completeExceptionally(configureError);
                } else {
                    result.complete(null);
                }
            });
        });
        return result;
    }

    private IllegalStateException errorPartitionNotAvailable(String operation) {
        return new IllegalStateException(String.format("Expected to %s partition %s, but raft partition is not available", operation, this.context.partitionMetadata().id().id()));
    }

    ZeebePartition zeebePartition() {
        return this.context.zeebePartition();
    }

    RaftPartition raftPartition() {
        return this.context.raftPartition();
    }

    int id() {
        return (Integer)this.context.partitionMetadata().id().id();
    }
}

