/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning.startup;

import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.partition.PartitionMetadata;
import io.atomix.raft.partition.RaftPartition;
import io.camunda.zeebe.broker.partitioning.startup.RaftPartitionFactory;
import io.camunda.zeebe.broker.partitioning.startup.ZeebePartitionFactory;
import io.camunda.zeebe.broker.partitioning.topology.TopologyManager;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageMonitor;
import io.camunda.zeebe.broker.system.partitions.ZeebePartition;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotStore;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.nio.file.Path;

public final class PartitionStartupContext {
    private final ActorSchedulingService schedulingService;
    private final TopologyManager topologyManager;
    private final ConcurrencyControl concurrencyControl;
    private final DiskSpaceUsageMonitor diskSpaceUsageMonitor;
    private final BrokerHealthCheckService healthCheckService;
    private final PartitionManagementService partitionManagementService;
    private final PartitionMetadata partitionMetadata;
    private final RaftPartitionFactory raftPartitionFactory;
    private final ZeebePartitionFactory zeebePartitionFactory;
    private final BrokerCfg brokerConfig;
    private final MeterRegistry brokerMeterRegistry;
    private Path partitionDirectory;
    private CompositeMeterRegistry partitionMeterRegistry;
    private FileBasedSnapshotStore snapshotStore;
    private RaftPartition raftPartition;
    private ZeebePartition zeebePartition;

    public PartitionStartupContext(ActorSchedulingService schedulingService, ConcurrencyControl concurrencyControl, TopologyManager topologyManager, DiskSpaceUsageMonitor diskSpaceUsageMonitor, BrokerHealthCheckService healthCheckService, PartitionManagementService partitionManagementService, PartitionMetadata partitionMetadata, RaftPartitionFactory raftPartitionFactory, ZeebePartitionFactory zeebePartitionFactory, BrokerCfg brokerConfig, MeterRegistry brokerMeterRegistry) {
        this.schedulingService = schedulingService;
        this.topologyManager = topologyManager;
        this.concurrencyControl = concurrencyControl;
        this.diskSpaceUsageMonitor = diskSpaceUsageMonitor;
        this.healthCheckService = healthCheckService;
        this.partitionManagementService = partitionManagementService;
        this.partitionMetadata = partitionMetadata;
        this.raftPartitionFactory = raftPartitionFactory;
        this.zeebePartitionFactory = zeebePartitionFactory;
        this.brokerConfig = brokerConfig;
        this.brokerMeterRegistry = brokerMeterRegistry;
    }

    public String toString() {
        return "PartitionStartupContext{partition=" + String.valueOf(this.partitionMetadata.id().id()) + "}";
    }

    public ActorSchedulingService schedulingService() {
        return this.schedulingService;
    }

    public ConcurrencyControl concurrencyControl() {
        return this.concurrencyControl;
    }

    public TopologyManager topologyManager() {
        return this.topologyManager;
    }

    public DiskSpaceUsageMonitor diskSpaceUsageMonitor() {
        return this.diskSpaceUsageMonitor;
    }

    public BrokerHealthCheckService brokerHealthCheckService() {
        return this.healthCheckService;
    }

    public PartitionManagementService partitionManagementService() {
        return this.partitionManagementService;
    }

    public PartitionMetadata partitionMetadata() {
        return this.partitionMetadata;
    }

    public RaftPartitionFactory raftPartitionFactory() {
        return this.raftPartitionFactory;
    }

    public ZeebePartitionFactory zeebePartitionFactory() {
        return this.zeebePartitionFactory;
    }

    public Path partitionDirectory() {
        return this.partitionDirectory;
    }

    public FileBasedSnapshotStore snapshotStore() {
        return this.snapshotStore;
    }

    public PartitionStartupContext snapshotStore(FileBasedSnapshotStore snapshotStore) {
        this.snapshotStore = snapshotStore;
        return this;
    }

    public PartitionStartupContext raftPartition(RaftPartition raftPartition) {
        this.raftPartition = raftPartition;
        return this;
    }

    public RaftPartition raftPartition() {
        return this.raftPartition;
    }

    public PartitionStartupContext zeebePartition(ZeebePartition zeebePartition) {
        this.zeebePartition = zeebePartition;
        return this;
    }

    public ZeebePartition zeebePartition() {
        return this.zeebePartition;
    }

    public BrokerCfg brokerConfig() {
        return this.brokerConfig;
    }

    public PartitionStartupContext partitionDirectory(Path partitionDirectory) {
        this.partitionDirectory = partitionDirectory;
        return this;
    }

    public PartitionStartupContext partitionMeterRegistry(CompositeMeterRegistry partitionMeterRegistry) {
        this.partitionMeterRegistry = partitionMeterRegistry;
        return this;
    }

    public CompositeMeterRegistry partitionMeterRegistry() {
        return this.partitionMeterRegistry;
    }

    public MeterRegistry brokerMeterRegistry() {
        return this.brokerMeterRegistry;
    }
}

