/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning.startup.steps;

import io.camunda.zeebe.broker.partitioning.startup.PartitionStartupContext;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.scheduler.startup.StartupStep;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;

public class MetricsStep
implements StartupStep<PartitionStartupContext> {
    public String getName() {
        return "Partition Metrics Startup Step";
    }

    public ActorFuture<PartitionStartupContext> startup(PartitionStartupContext context) {
        MeterRegistry brokerRegistry = context.brokerMeterRegistry();
        Integer partitionId = (Integer)context.partitionMetadata().id().id();
        CompositeMeterRegistry partitionRegistry = MicrometerUtil.wrap((MeterRegistry)brokerRegistry, (Tags)MicrometerUtil.PartitionKeyNames.tags((int)partitionId));
        context.partitionMeterRegistry(partitionRegistry);
        return CompletableActorFuture.completed((Object)context);
    }

    public ActorFuture<PartitionStartupContext> shutdown(PartitionStartupContext context) {
        CompositeMeterRegistry partitionRegistry = context.partitionMeterRegistry();
        if (partitionRegistry != null) {
            MicrometerUtil.discard((CompositeMeterRegistry)partitionRegistry);
            context.partitionMeterRegistry(null);
        }
        return CompletableActorFuture.completed((Object)context);
    }
}

