/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning.startup.steps;

import io.camunda.zeebe.broker.partitioning.startup.PartitionStartupContext;
import io.camunda.zeebe.broker.partitioning.topology.TopologyManager;
import io.camunda.zeebe.broker.system.partitions.PartitionHealthBroadcaster;
import io.camunda.zeebe.broker.system.partitions.ZeebePartition;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.startup.StartupStep;

public final class PartitionRegistrationStep
implements StartupStep<PartitionStartupContext> {
    public String getName() {
        return "Partition Registration";
    }

    public ActorFuture<PartitionStartupContext> startup(PartitionStartupContext context) {
        ActorFuture result = context.concurrencyControl().createFuture();
        Integer partitionId = (Integer)context.partitionMetadata().id().id();
        ZeebePartition zeebePartition = context.zeebePartition();
        TopologyManager topologyManager = context.topologyManager();
        zeebePartition.addFailureListener(new PartitionHealthBroadcaster(partitionId, topologyManager::onHealthChanged));
        context.diskSpaceUsageMonitor().addDiskUsageListener(zeebePartition);
        context.brokerHealthCheckService().registerMonitoredPartition(partitionId, zeebePartition);
        result.complete((Object)context);
        return result;
    }

    public ActorFuture<PartitionStartupContext> shutdown(PartitionStartupContext context) {
        ActorFuture result = context.concurrencyControl().createFuture();
        Integer partitionId = (Integer)context.partitionMetadata().id().id();
        context.diskSpaceUsageMonitor().removeDiskUsageListener(context.zeebePartition());
        context.brokerHealthCheckService().removeMonitoredPartition(partitionId);
        context.topologyManager().removePartition(partitionId);
        result.complete((Object)context);
        return result;
    }
}

