/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning.startup.steps;

import io.camunda.zeebe.broker.partitioning.startup.PartitionStartupContext;
import io.camunda.zeebe.broker.system.partitions.ZeebePartition;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.startup.StartupStep;
import io.micrometer.core.instrument.MeterRegistry;

public final class ZeebePartitionStep
implements StartupStep<PartitionStartupContext> {
    public String getName() {
        return "Zeebe Partition";
    }

    public ActorFuture<PartitionStartupContext> startup(PartitionStartupContext context) {
        ActorFuture result = context.concurrencyControl().createFuture();
        ZeebePartition zeebePartition = context.zeebePartitionFactory().constructPartition(context.raftPartition(), context.snapshotStore(), (MeterRegistry)context.partitionMeterRegistry());
        ActorFuture submit = context.schedulingService().submitActor((Actor)zeebePartition);
        context.concurrencyControl().runOnCompletion(submit, (ignored, failure) -> {
            if (failure == null) {
                result.complete((Object)context.zeebePartition(zeebePartition));
            } else {
                result.completeExceptionally(failure);
            }
        });
        return result;
    }

    public ActorFuture<PartitionStartupContext> shutdown(PartitionStartupContext partitionStartupContext) {
        ActorFuture result = partitionStartupContext.concurrencyControl().createFuture();
        ZeebePartition zeebePartition = partitionStartupContext.zeebePartition();
        if (zeebePartition == null) {
            result.complete((Object)partitionStartupContext);
            return result;
        }
        ActorFuture<Void> close = zeebePartition.closeAsync();
        partitionStartupContext.concurrencyControl().runOnCompletion(close, (ignored, failure) -> {
            if (failure == null) {
                result.complete((Object)partitionStartupContext.zeebePartition(null));
            } else {
                result.completeExceptionally(failure);
            }
        });
        return result;
    }
}

