/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system;

import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.broker.client.api.BrokerTopologyListener;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.gateway.Gateway;
import io.camunda.zeebe.gateway.Loggers;
import io.camunda.zeebe.gateway.impl.configuration.GatewayCfg;
import io.camunda.zeebe.gateway.impl.stream.JobStreamClient;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Duration;
import org.agrona.CloseHelper;

public final class EmbeddedGatewayService
implements AutoCloseable {
    private final Gateway gateway;
    private final BrokerClient brokerClient;
    private final JobStreamClient jobStreamClient;
    private final ConcurrencyControl concurrencyControl;

    public EmbeddedGatewayService(Duration shutdownTimeout, BrokerCfg configuration, IdentityConfiguration identityConfiguration, ActorSchedulingService actorScheduler, ConcurrencyControl concurrencyControl, JobStreamClient jobStreamClient, BrokerClient brokerClient, MeterRegistry meterRegistry) {
        this.concurrencyControl = concurrencyControl;
        this.brokerClient = brokerClient;
        this.jobStreamClient = jobStreamClient;
        this.gateway = new Gateway(shutdownTimeout, (GatewayCfg)configuration.getGateway(), identityConfiguration, brokerClient, actorScheduler, jobStreamClient.streamer(), meterRegistry);
    }

    @Override
    public void close() {
        CloseHelper.closeAll(error -> Loggers.GATEWAY_LOGGER.warn("Error occurred while shutting down embedded gateway", error), (AutoCloseable[])new AutoCloseable[]{this.gateway, this.brokerClient, this.jobStreamClient});
    }

    public Gateway get() {
        return this.gateway;
    }

    public ActorFuture<Gateway> start() {
        this.concurrencyControl.runOnCompletion(this.jobStreamClient.start(), (ok, error) -> this.brokerClient.getTopologyManager().addTopologyListener((BrokerTopologyListener)this.jobStreamClient));
        return this.gateway.start();
    }
}

