/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;
import java.time.Duration;
import org.slf4j.Logger;
import org.springframework.util.unit.DataSize;

public class DiskCfg
implements ConfigurationEntry {
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private static final boolean DEFAULT_DISK_MONITORING_ENABLED = true;
    private static final DataSize DISABLED_DISK_FREESPACE = DataSize.ofBytes((long)0L);
    private static final Duration DEFAULT_DISK_USAGE_MONITORING_DELAY = Duration.ofSeconds(1L);
    private boolean enableMonitoring = true;
    private Duration monitoringInterval = DEFAULT_DISK_USAGE_MONITORING_DELAY;
    private FreeSpaceCfg freeSpace = new FreeSpaceCfg();

    @Override
    public void init(BrokerCfg globalConfig, String brokerBase) {
        this.freeSpace.init(globalConfig, brokerBase);
        if (!this.enableMonitoring) {
            LOG.info("Disk usage monitoring is disabled, setting required freespace to {}", (Object)DISABLED_DISK_FREESPACE);
            this.freeSpace.setReplication(DISABLED_DISK_FREESPACE);
            this.freeSpace.setProcessing(DISABLED_DISK_FREESPACE);
        }
    }

    public boolean isEnableMonitoring() {
        return this.enableMonitoring;
    }

    public void setEnableMonitoring(boolean enableMonitoring) {
        this.enableMonitoring = enableMonitoring;
    }

    public Duration getMonitoringInterval() {
        return this.monitoringInterval;
    }

    public void setMonitoringInterval(Duration monitoringInterval) {
        this.monitoringInterval = monitoringInterval;
    }

    public FreeSpaceCfg getFreeSpace() {
        return this.freeSpace;
    }

    public void setFreeSpace(FreeSpaceCfg freeSpace) {
        this.freeSpace = freeSpace;
    }

    public String toString() {
        return "DiskCfg{enableMonitoring=" + this.enableMonitoring + ", freeSpace=" + String.valueOf(this.freeSpace) + "}";
    }

    public static class FreeSpaceCfg
    implements ConfigurationEntry {
        private static final DataSize DEFAULT_PROCESSING_FREESPACE = DataSize.ofGigabytes((long)2L);
        private static final DataSize DEFAULT_REPLICATION_FREESPACE = DataSize.ofGigabytes((long)1L);
        private DataSize processing = DEFAULT_PROCESSING_FREESPACE;
        private DataSize replication = DEFAULT_REPLICATION_FREESPACE;

        public DataSize getProcessing() {
            return this.processing;
        }

        public void setProcessing(DataSize processing) {
            this.processing = processing;
        }

        public DataSize getReplication() {
            return this.replication;
        }

        public void setReplication(DataSize replication) {
            this.replication = replication;
        }

        public String toString() {
            return "FreeSpaceCfg{processing='" + String.valueOf(this.processing) + "', replication='" + String.valueOf(this.replication) + "'}";
        }
    }
}

