/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;
import java.time.Duration;

public final class MembershipCfg
implements ConfigurationEntry {
    private static final boolean DEFAULT_BROADCAST_UPDATES = false;
    private static final boolean DEFAULT_BROADCAST_DISPUTES = true;
    private static final boolean DEFAULT_NOTIFY_SUSPECT = false;
    private static final Duration DEFAULT_GOSSIP_INTERVAL = Duration.ofMillis(250L);
    private static final int DEFAULT_GOSSIP_FANOUT = 2;
    private static final Duration DEFAULT_PROBE_INTERVAL = Duration.ofMillis(1000L);
    private static final Duration DEFAULT_PROBE_TIMEOUT = Duration.ofMillis(100L);
    private static final int DEFAULT_SUSPECT_PROBES = 3;
    private static final Duration DEFAULT_FAILURE_TIMEOUT = Duration.ofMillis(10000L);
    private static final Duration DEFAULT_SYNC_INTERVAL = Duration.ofMillis(10000L);
    private boolean broadcastUpdates = false;
    private boolean broadcastDisputes = true;
    private boolean notifySuspect = false;
    private Duration gossipInterval = DEFAULT_GOSSIP_INTERVAL;
    private int gossipFanout = 2;
    private Duration probeInterval = DEFAULT_PROBE_INTERVAL;
    private Duration probeTimeout = DEFAULT_PROBE_TIMEOUT;
    private int suspectProbes = 3;
    private Duration failureTimeout = DEFAULT_FAILURE_TIMEOUT;
    private Duration syncInterval = DEFAULT_SYNC_INTERVAL;

    public boolean isBroadcastUpdates() {
        return this.broadcastUpdates;
    }

    public MembershipCfg setBroadcastUpdates(boolean broadcastUpdates) {
        this.broadcastUpdates = broadcastUpdates;
        return this;
    }

    public boolean isBroadcastDisputes() {
        return this.broadcastDisputes;
    }

    public MembershipCfg setBroadcastDisputes(boolean broadcastDisputes) {
        this.broadcastDisputes = broadcastDisputes;
        return this;
    }

    public boolean isNotifySuspect() {
        return this.notifySuspect;
    }

    public MembershipCfg setNotifySuspect(boolean notifySuspect) {
        this.notifySuspect = notifySuspect;
        return this;
    }

    public Duration getGossipInterval() {
        return this.gossipInterval;
    }

    public MembershipCfg setGossipInterval(Duration gossipInterval) {
        this.gossipInterval = gossipInterval;
        return this;
    }

    public int getGossipFanout() {
        return this.gossipFanout;
    }

    public MembershipCfg setGossipFanout(int gossipFanout) {
        this.gossipFanout = gossipFanout;
        return this;
    }

    public Duration getProbeInterval() {
        return this.probeInterval;
    }

    public MembershipCfg setProbeInterval(Duration probeInterval) {
        this.probeInterval = probeInterval;
        return this;
    }

    public Duration getProbeTimeout() {
        return this.probeTimeout;
    }

    public MembershipCfg setProbeTimeout(Duration probeTimeout) {
        this.probeTimeout = probeTimeout;
        return this;
    }

    public int getSuspectProbes() {
        return this.suspectProbes;
    }

    public MembershipCfg setSuspectProbes(int suspectProbes) {
        this.suspectProbes = suspectProbes;
        return this;
    }

    public Duration getFailureTimeout() {
        return this.failureTimeout;
    }

    public MembershipCfg setFailureTimeout(Duration failureTimeout) {
        this.failureTimeout = failureTimeout;
        return this;
    }

    public Duration getSyncInterval() {
        return this.syncInterval;
    }

    public MembershipCfg setSyncInterval(Duration syncInterval) {
        this.syncInterval = syncInterval;
        return this;
    }

    public String toString() {
        return "MembershipCfg{broadcastUpdates=" + this.broadcastUpdates + ", broadcastDisputes=" + this.broadcastDisputes + ", notifySuspect=" + this.notifySuspect + ", gossipInterval=" + String.valueOf(this.gossipInterval) + ", gossipFanout=" + this.gossipFanout + ", probeInterval=" + String.valueOf(this.probeInterval) + ", probeTimeout=" + String.valueOf(this.probeTimeout) + ", suspectProbes=" + this.suspectProbes + ", failureTimeout=" + String.valueOf(this.failureTimeout) + ", syncInterval=" + String.valueOf(this.syncInterval) + "}";
    }
}

