/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;
import io.camunda.zeebe.broker.system.configuration.SecurityCfg;
import io.camunda.zeebe.broker.system.configuration.SocketBindingCfg;
import java.time.Duration;
import java.util.Optional;
import org.springframework.util.unit.DataSize;

public final class NetworkCfg
implements ConfigurationEntry {
    public static final String DEFAULT_HOST = "0.0.0.0";
    public static final int DEFAULT_COMMAND_API_PORT = 26501;
    public static final int DEFAULT_INTERNAL_API_PORT = 26502;
    public static final DataSize DEFAULT_MAX_MESSAGE_SIZE = DataSize.ofMegabytes((long)4L);
    private String host = "0.0.0.0";
    private int portOffset = 0;
    private DataSize maxMessageSize = DEFAULT_MAX_MESSAGE_SIZE;
    private String advertisedHost;
    private Duration heartbeatTimeout = Duration.ofSeconds(15L);
    private Duration heartbeatInterval = Duration.ofSeconds(5L);
    private final SocketBindingCfg.CommandApiCfg commandApi = new SocketBindingCfg.CommandApiCfg();
    private SocketBindingCfg.InternalApiCfg internalApi = new SocketBindingCfg.InternalApiCfg();
    private SecurityCfg security = new SecurityCfg();

    @Override
    public void init(BrokerCfg brokerCfg, String brokerBase) {
        this.applyDefaults();
        this.security.init(brokerCfg, brokerBase);
    }

    public void applyDefaults() {
        this.commandApi.applyDefaults(this);
        this.internalApi.applyDefaults(this);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getAdvertisedHost() {
        return Optional.ofNullable(this.advertisedHost).orElse(this.getHost());
    }

    public void setAdvertisedHost(String advertisedHost) {
        this.advertisedHost = advertisedHost;
    }

    public int getPortOffset() {
        return this.portOffset;
    }

    public void setPortOffset(int portOffset) {
        this.portOffset = portOffset;
    }

    public long getMaxMessageSizeInBytes() {
        return this.maxMessageSize.toBytes();
    }

    public DataSize getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(DataSize maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public Duration getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public void setHeartbeatTimeout(Duration heartbeatTimeout) {
        this.heartbeatTimeout = heartbeatTimeout;
    }

    public Duration getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(Duration heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public SocketBindingCfg.CommandApiCfg getCommandApi() {
        return this.commandApi;
    }

    public SocketBindingCfg getInternalApi() {
        return this.internalApi;
    }

    public void setInternalApi(SocketBindingCfg.InternalApiCfg internalApi) {
        this.internalApi = internalApi;
    }

    public SecurityCfg getSecurity() {
        return this.security;
    }

    public void setSecurity(SecurityCfg security) {
        this.security = security;
    }

    public String toString() {
        return "NetworkCfg{host='" + this.host + "', portOffset=" + this.portOffset + "', maxMessageSize=" + String.valueOf(this.maxMessageSize) + ", heartbeatTimeout=" + String.valueOf(this.heartbeatTimeout) + ", heartbeatInterval=" + String.valueOf(this.heartbeatInterval) + ", commandApi=" + String.valueOf(this.commandApi) + ", internalApi=" + String.valueOf(this.internalApi) + ", security=" + String.valueOf(this.security) + "}";
    }
}

