/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;
import io.camunda.zeebe.db.AccessMetricsConfiguration;
import io.camunda.zeebe.db.impl.rocksdb.RocksDbConfiguration;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import org.springframework.util.unit.DataSize;

public final class RocksdbCfg
implements ConfigurationEntry {
    private Properties columnFamilyOptions;
    private boolean enableStatistics = false;
    private AccessMetricsConfiguration.Kind accessMetrics = AccessMetricsConfiguration.Kind.NONE;
    private DataSize memoryLimit = DataSize.ofBytes((long)0x20000000L);
    private int maxOpenFiles = -1;
    private int maxWriteBufferNumber = 6;
    private int minWriteBufferNumberToMerge = 3;
    private int ioRateBytesPerSecond = 0;
    private boolean disableWal = true;
    private boolean enableSstPartitioning = true;

    @Override
    public void init(BrokerCfg globalConfig, String brokerBase) {
        this.columnFamilyOptions = this.columnFamilyOptions == null ? new Properties() : RocksdbCfg.initColumnFamilyOptions(this.columnFamilyOptions);
    }

    private static Properties initColumnFamilyOptions(Properties original) {
        Properties result = new Properties();
        original.entrySet().stream().map(RocksDBColumnFamilyOption::new).forEach(entry -> result.put(entry.key, entry.value));
        return result;
    }

    public Properties getColumnFamilyOptions() {
        return this.columnFamilyOptions;
    }

    public void setColumnFamilyOptions(Properties columnFamilyOptions) {
        this.columnFamilyOptions = columnFamilyOptions;
    }

    public boolean isEnableStatistics() {
        return this.enableStatistics;
    }

    public void setEnableStatistics(boolean enableStatistics) {
        this.enableStatistics = enableStatistics;
    }

    public DataSize getMemoryLimit() {
        return this.memoryLimit;
    }

    public void setMemoryLimit(DataSize memoryLimit) {
        this.memoryLimit = memoryLimit;
    }

    public int getMaxOpenFiles() {
        return this.maxOpenFiles;
    }

    public void setMaxOpenFiles(int maxOpenFiles) {
        this.maxOpenFiles = maxOpenFiles;
    }

    public int getMaxWriteBufferNumber() {
        return this.maxWriteBufferNumber;
    }

    public void setMaxWriteBufferNumber(int maxWriteBufferNumber) {
        this.maxWriteBufferNumber = maxWriteBufferNumber;
    }

    public int getMinWriteBufferNumberToMerge() {
        return this.minWriteBufferNumberToMerge;
    }

    public void setMinWriteBufferNumberToMerge(int minWriteBufferNumberToMerge) {
        this.minWriteBufferNumberToMerge = minWriteBufferNumberToMerge;
    }

    public int getIoRateBytesPerSecond() {
        return this.ioRateBytesPerSecond;
    }

    public void setIoRateBytesPerSecond(int ioRateBytesPerSecond) {
        this.ioRateBytesPerSecond = ioRateBytesPerSecond;
    }

    public boolean isDisableWal() {
        return this.disableWal;
    }

    public void setDisableWal(boolean disableWal) {
        this.disableWal = disableWal;
    }

    public boolean isEnableSstPartitioning() {
        return this.enableSstPartitioning;
    }

    public void setEnableSstPartitioning(boolean enableSstPartitioning) {
        this.enableSstPartitioning = enableSstPartitioning;
    }

    public AccessMetricsConfiguration.Kind getAccessMetrics() {
        return this.accessMetrics;
    }

    public void setAccessMetrics(AccessMetricsConfiguration.Kind accessMetrics) {
        this.accessMetrics = accessMetrics;
    }

    public RocksDbConfiguration createRocksDbConfiguration() {
        return new RocksDbConfiguration().setColumnFamilyOptions(this.columnFamilyOptions).setMaxOpenFiles(this.maxOpenFiles).setMaxWriteBufferNumber(this.maxWriteBufferNumber).setMemoryLimit(this.memoryLimit.toBytes()).setMinWriteBufferNumberToMerge(this.minWriteBufferNumberToMerge).setStatisticsEnabled(this.enableStatistics).setIoRateBytesPerSecond(this.ioRateBytesPerSecond).setWalDisabled(this.disableWal).setSstPartitioningEnabled(this.enableSstPartitioning);
    }

    public String toString() {
        return "RocksdbCfg{columnFamilyOptions=" + String.valueOf(this.columnFamilyOptions) + ", enableStatistics=" + this.enableStatistics + ", accessMetrics=" + String.valueOf(this.accessMetrics) + ", memoryLimit=" + String.valueOf(this.memoryLimit) + ", maxOpenFiles=" + this.maxOpenFiles + ", maxWriteBufferNumber=" + this.maxWriteBufferNumber + ", minWriteBufferNumberToMerge=" + this.minWriteBufferNumberToMerge + ", ioRateBytesPerSecond=" + this.ioRateBytesPerSecond + ", disableWal=" + this.disableWal + ", enableSstPartitioning=" + this.enableSstPartitioning + "}";
    }

    private static final class RocksDBColumnFamilyOption {
        private static final Pattern DOT_CHAR_PATTERN = Pattern.compile("\\.");
        private static final String UNDERSCORE_CHAR = "_";
        private final String key;
        private final Object value;

        private RocksDBColumnFamilyOption(Map.Entry<Object, Object> entry) {
            Objects.requireNonNull(entry.getKey());
            this.key = RocksDBColumnFamilyOption.replaceAllDotCharsWithUnderscore(entry.getKey().toString());
            this.value = entry.getValue();
        }

        private static String replaceAllDotCharsWithUnderscore(String key) {
            return DOT_CHAR_PATTERN.matcher(key).replaceAll(UNDERSCORE_CHAR);
        }
    }
}

