/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration.backup;

import io.camunda.zeebe.backup.gcs.GcsBackupConfig;
import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;
import java.util.Objects;

public class GcsBackupStoreConfig
implements ConfigurationEntry {
    private String bucketName;
    private String basePath;
    private String host;
    private GcsBackupStoreAuth auth = GcsBackupStoreAuth.AUTO;

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public GcsBackupStoreAuth getAuth() {
        return this.auth;
    }

    public void setAuth(GcsBackupStoreAuth auth) {
        this.auth = auth;
    }

    public static GcsBackupConfig toStoreConfig(GcsBackupStoreConfig config) {
        GcsBackupConfig.Builder storeConfig = new GcsBackupConfig.Builder().withBucketName(config.getBucketName()).withBasePath(config.getBasePath()).withHost(config.getHost());
        GcsBackupConfig.Builder authenticated = switch (config.getAuth().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> storeConfig.withoutAuthentication();
            case 1 -> storeConfig.withAutoAuthentication();
        };
        return authenticated.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GcsBackupStoreConfig that = (GcsBackupStoreConfig)o;
        return Objects.equals(this.bucketName, that.bucketName) && Objects.equals(this.basePath, that.basePath) && Objects.equals(this.host, that.host) && this.auth == that.auth;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bucketName, this.basePath, this.host, this.auth});
    }

    public String toString() {
        return "GcsBackupStoreConfig{bucketName='" + this.bucketName + "', basePath='" + this.basePath + "', host='" + this.host + "', auth=" + String.valueOf((Object)this.auth) + "}";
    }

    public static enum GcsBackupStoreAuth {
        NONE,
        AUTO;

    }
}

