/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.monitoring;

import io.camunda.zeebe.broker.system.monitoring.BrokerStepMetricsDoc;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.TimeGauge;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class BrokerStepMetrics {
    private final Map<String, AtomicLong> startup = new HashMap<String, AtomicLong>();
    private final Map<String, AtomicLong> close = new HashMap<String, AtomicLong>();
    private final MeterRegistry registry;

    public BrokerStepMetrics(MeterRegistry registry) {
        this.registry = Objects.requireNonNull(registry, "must specify a meter registry");
    }

    public CloseableSilently createStartupTimer(String stepName) {
        AtomicLong timerTracker = this.startup.computeIfAbsent(stepName, name -> this.registerMetric(BrokerStepMetricsDoc.STARTUP, (String)name));
        return MicrometerUtil.timer(timerTracker::set, (TimeUnit)TimeUnit.MILLISECONDS, (Clock)this.registry.config().clock());
    }

    public CloseableSilently createCloseTimer(String stepName) {
        AtomicLong timerTracker = this.close.computeIfAbsent(stepName, name -> this.registerMetric(BrokerStepMetricsDoc.CLOSE, (String)name));
        return MicrometerUtil.timer(timerTracker::set, (TimeUnit)TimeUnit.MILLISECONDS, (Clock)this.registry.config().clock());
    }

    private AtomicLong registerMetric(BrokerStepMetricsDoc meterDoc, String stepName) {
        AtomicLong timeTracker = new AtomicLong();
        TimeGauge.builder((String)meterDoc.getName(), (Object)timeTracker, (TimeUnit)TimeUnit.MILLISECONDS, AtomicLong::longValue).description(meterDoc.getDescription()).tag("stepName", stepName).register(this.registry);
        return timeTracker;
    }
}

