/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions;

import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.TimeGauge;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class RoleMetrics {
    private final AtomicLong leaderTransitionLatency = new AtomicLong();
    private final Clock clock;

    public RoleMetrics(MeterRegistry registry, int partitionId) {
        this.clock = registry.config().clock();
        RoleMetricsDoc meterDoc = RoleMetricsDoc.LEADER_TRANSITION_LATENCY;
        TimeGauge.builder((String)meterDoc.getName(), (Object)this.leaderTransitionLatency, (TimeUnit)TimeUnit.MILLISECONDS, Number::longValue).description(meterDoc.getDescription()).tag(MicrometerUtil.PartitionKeyNames.PARTITION.asString(), String.valueOf(partitionId)).register(registry);
    }

    public CloseableSilently startLeaderTransitionLatencyTimer() {
        return MicrometerUtil.timer(this.leaderTransitionLatency::set, (TimeUnit)TimeUnit.MILLISECONDS, (Clock)this.clock);
    }

    public static enum RoleMetricsDoc implements ExtendedMeterDocumentation
    {
        LEADER_TRANSITION_LATENCY{

            public String getDescription() {
                return "The time (in ms) needed for the engine services to transition to leader and be ready to process new requests";
            }

            public String getName() {
                return "zeebe.leader.transition.latency";
            }

            public Meter.Type getType() {
                return Meter.Type.GAUGE;
            }

            public KeyName[] getKeyNames() {
                return MicrometerUtil.PartitionKeyNames.values();
            }
        };

    }
}

