/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.partitioning.PartitionAdminAccess;
import io.camunda.zeebe.broker.system.partitions.PartitionAdminControl;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.state.processing.DbBannedInstanceState;
import io.camunda.zeebe.logstreams.log.LogAppendEntry;
import io.camunda.zeebe.logstreams.log.LogStreamWriter;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.value.error.ErrorRecord;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.ErrorIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.stream.impl.records.RecordBatchEntry;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.slf4j.Logger;

class ZeebePartitionAdminAccess
implements PartitionAdminAccess {
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private final ConcurrencyControl concurrencyControl;
    private final int partitionId;
    private final PartitionAdminControl adminControl;

    ZeebePartitionAdminAccess(ConcurrencyControl concurrencyControl, int partitionId, PartitionAdminControl adminControl) {
        this.concurrencyControl = Objects.requireNonNull(concurrencyControl);
        this.partitionId = partitionId;
        this.adminControl = Objects.requireNonNull(adminControl);
    }

    @Override
    public Optional<PartitionAdminAccess> forPartition(int partitionId) {
        if (this.partitionId == partitionId) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    @Override
    public ActorFuture<Void> takeSnapshot() {
        ActorFuture completed = this.concurrencyControl.createFuture();
        this.concurrencyControl.run(() -> {
            try {
                this.adminControl.triggerSnapshot();
                completed.complete(null);
            }
            catch (Exception e) {
                completed.completeExceptionally((Throwable)e);
            }
        });
        return completed;
    }

    @Override
    public ActorFuture<Void> pauseExporting() {
        ActorFuture completed = this.concurrencyControl.createFuture();
        this.concurrencyControl.run(() -> {
            try {
                boolean pauseStatePersisted = this.adminControl.pauseExporting();
                if (this.adminControl.getExporterDirector() != null && pauseStatePersisted) {
                    this.adminControl.getExporterDirector().pauseExporting().onComplete((BiConsumer)completed);
                } else {
                    completed.complete(null);
                }
            }
            catch (IOException e) {
                LOG.error("Could not pause exporting", (Throwable)e);
                completed.completeExceptionally((Throwable)e);
            }
        });
        return completed;
    }

    @Override
    public ActorFuture<Void> softPauseExporting() {
        ActorFuture completed = this.concurrencyControl.createFuture();
        this.concurrencyControl.run(() -> {
            try {
                boolean softPauseStatePersisted = this.adminControl.softPauseExporting();
                if (this.adminControl.getExporterDirector() != null && softPauseStatePersisted) {
                    this.adminControl.getExporterDirector().softPauseExporting().onComplete((BiConsumer)completed);
                } else {
                    completed.complete(null);
                }
            }
            catch (IOException e) {
                LOG.error("Could not soft pause exporting", (Throwable)e);
                completed.completeExceptionally((Throwable)e);
            }
        });
        return completed;
    }

    @Override
    public ActorFuture<Void> resumeExporting() {
        ActorFuture completed = this.concurrencyControl.createFuture();
        this.concurrencyControl.run(() -> {
            try {
                this.adminControl.resumeExporting();
                if (this.adminControl.getExporterDirector() != null && this.adminControl.shouldExport()) {
                    this.adminControl.getExporterDirector().resumeExporting().onComplete((BiConsumer)completed);
                } else {
                    completed.complete(null);
                }
            }
            catch (IOException e) {
                LOG.error("Could not resume exporting", (Throwable)e);
                completed.completeExceptionally((Throwable)e);
            }
        });
        return completed;
    }

    @Override
    public ActorFuture<Void> pauseProcessing() {
        ActorFuture completed = this.concurrencyControl.createFuture();
        this.concurrencyControl.run(() -> {
            try {
                this.adminControl.pauseProcessing();
                if (this.adminControl.getStreamProcessor() != null && !this.adminControl.shouldProcess()) {
                    this.adminControl.getStreamProcessor().pauseProcessing().onComplete((BiConsumer)completed);
                } else {
                    completed.complete(null);
                }
            }
            catch (IOException e) {
                LOG.error("Could not pause processing state", (Throwable)e);
                completed.completeExceptionally((Throwable)e);
            }
        });
        return completed;
    }

    @Override
    public ActorFuture<Void> resumeProcessing() {
        ActorFuture completed = this.concurrencyControl.createFuture();
        this.concurrencyControl.run(() -> {
            try {
                this.adminControl.resumeProcessing();
                if (this.adminControl.getStreamProcessor() != null && this.adminControl.shouldProcess()) {
                    this.adminControl.getStreamProcessor().resumeProcessing();
                }
                completed.complete(null);
            }
            catch (IOException e) {
                LOG.error("Could not resume processing", (Throwable)e);
                completed.completeExceptionally((Throwable)e);
            }
        });
        return completed;
    }

    @Override
    public ActorFuture<Void> banInstance(long processInstanceKey) {
        ActorFuture future = this.concurrencyControl.createFuture();
        this.concurrencyControl.run(() -> {
            try {
                this.adminControl.getLogStream().newLogStreamWriter().onComplete((writer, error) -> {
                    if (error != null) {
                        LOG.error("Could not retrieve writer to write error record for process instance.", error);
                        future.completeExceptionally(error);
                        return;
                    }
                    this.writeErrorEventAndBanInstance(processInstanceKey, (LogStreamWriter)writer, (ActorFuture<Void>)future);
                });
            }
            catch (Exception e) {
                LOG.error("Failure on writing error record to ban instance {} onto the LogStream.", (Object)processInstanceKey, (Object)e);
                future.completeExceptionally((Throwable)e);
            }
        });
        return future;
    }

    private void writeErrorEventAndBanInstance(long processInstanceKey, LogStreamWriter writer, ActorFuture<Void> future) {
        ZeebePartitionAdminAccess.tryWriteErrorEvent(writer, processInstanceKey).ifRightOrLeft(position -> {
            LOG.info("Wrote error record on position {}", position);
            this.banInstanceInState(processInstanceKey);
            LOG.info("Successfully banned instance with key {}", (Object)processInstanceKey);
            future.complete(null);
        }, writeFailure -> {
            String errorMsg = String.format("Failure %s on writing error record to ban instance %d", writeFailure, processInstanceKey);
            future.completeExceptionally((Throwable)new IllegalStateException(errorMsg));
            LOG.error(errorMsg);
        });
    }

    private void banInstanceInState(long processInstanceKey) {
        ZeebeDb zeebeDb = this.adminControl.getZeebeDb();
        TransactionContext context = zeebeDb.createContext();
        DbBannedInstanceState dbBannedInstanceState = new DbBannedInstanceState(zeebeDb, context);
        dbBannedInstanceState.banProcessInstance(processInstanceKey);
    }

    private static Either<LogStreamWriter.WriteFailure, Long> tryWriteErrorEvent(LogStreamWriter writer, long processInstanceKey) {
        ErrorRecord errorRecord = new ErrorRecord();
        errorRecord.initErrorRecord((Throwable)new Exception("Instance was banned from outside."), -1L);
        errorRecord.setProcessInstanceKey(processInstanceKey);
        RecordMetadata recordMetadata = new RecordMetadata().recordType(RecordType.EVENT).valueType(ValueType.ERROR).intent((Intent)ErrorIntent.CREATED).recordVersion(1).rejectionType(RejectionType.NULL_VAL).rejectionReason("");
        RecordBatchEntry entry = RecordBatchEntry.createEntry((long)processInstanceKey, (RecordMetadata)recordMetadata, (int)-1, (BufferWriter)errorRecord);
        return writer.tryWrite((LogAppendEntry)entry);
    }
}

