/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.system.partitions.PartitionTransition;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.util.health.HealthIssue;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;

final class PartitionTransitionProcess {
    public static final String MSG_PREPARE_TRANSITION = "Prepare transition from {}[term: {}] -> {}[term: {}]";
    public static final String MSG_PREPARE_TRANSITION_STEP = "Prepare transition from {}[term: {}] -> {}[term: {}] - preparing {}";
    public static final String MSG_PREPARE_TRANSITION_COMPLETED = "Prepare transition from {}[term: {}] -> {}[term: {}] completed";
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private static final long STEP_TIMEOUT_MS = Duration.ofSeconds(60L).toMillis();
    private PartitionTransitionStep currentStep;
    private final List<PartitionTransitionStep> pendingSteps;
    private final Deque<PartitionTransitionStep> stepsToPrepare = new ArrayDeque<PartitionTransitionStep>();
    private final ConcurrencyControl concurrencyControl;
    private final PartitionTransitionContext context;
    private final long term;
    private final RaftServer.Role role;
    private boolean cancelRequested = false;
    private boolean completed = false;
    private long stepStartedAtMs = -1L;

    PartitionTransitionProcess(List<PartitionTransitionStep> pendingSteps, ConcurrencyControl concurrencyControl, PartitionTransitionContext context, long term, RaftServer.Role role) {
        this.pendingSteps = new ArrayList<PartitionTransitionStep>((Collection)Objects.requireNonNull(pendingSteps));
        pendingSteps.forEach(this.stepsToPrepare::push);
        this.concurrencyControl = Objects.requireNonNull(concurrencyControl);
        this.context = Objects.requireNonNull(context);
        context.setConcurrencyControl(concurrencyControl);
        this.term = term;
        this.role = Objects.requireNonNull(role);
    }

    void start(ActorFuture<Void> future) {
        LOG.info("Transition to {} on term {} starting", (Object)this.role, (Object)this.term);
        if (this.pendingSteps.isEmpty()) {
            LOG.info("No steps defined for transition");
            future.complete(null);
            return;
        }
        this.proceedWithTransition(future);
    }

    private void proceedWithTransition(ActorFuture<Void> future) {
        if (this.cancelRequested) {
            LOG.info("Cancelling transition to {} on term {}", (Object)this.role, (Object)this.term);
            future.completeExceptionally((Throwable)new PartitionTransition.CancelledPartitionTransition());
            this.completed = true;
            return;
        }
        this.concurrencyControl.run(() -> {
            PartitionTransitionStep nextStep;
            this.currentStep = nextStep = this.pendingSteps.remove(0);
            this.stepStartedAtMs = ActorClock.currentTimeMillis();
            LOG.info("Transition to {} on term {} - transitioning {}", new Object[]{this.role, this.term, nextStep.getName()});
            nextStep.transitionTo(this.context, this.term, this.role).onComplete((ok, error) -> this.onStepCompletion(future, (Throwable)error));
        });
    }

    private void onStepCompletion(ActorFuture<Void> future, Throwable error) {
        if (error != null) {
            future.completeExceptionally(error);
            return;
        }
        if (this.pendingSteps.isEmpty()) {
            LOG.info("Transition to {} on term {} completed", (Object)this.role, (Object)this.term);
            future.complete(null);
            this.completed = true;
            this.currentStep = null;
            this.stepStartedAtMs = -1L;
            return;
        }
        this.proceedWithTransition(future);
    }

    ActorFuture<Void> prepare(long newTerm, RaftServer.Role newRole) {
        LOG.info(MSG_PREPARE_TRANSITION, new Object[]{this.context.getCurrentRole(), this.context.getCurrentTerm(), newRole, newTerm});
        ActorFuture prepareFuture = this.concurrencyControl.createFuture();
        if (this.stepsToPrepare.isEmpty()) {
            LOG.info("No steps to prepare transition");
            prepareFuture.complete(null);
        } else {
            this.proceedWithPrepare((ActorFuture<Void>)prepareFuture, newTerm, newRole);
        }
        return prepareFuture;
    }

    private void proceedWithPrepare(ActorFuture<Void> future, long newTerm, RaftServer.Role newRole) {
        this.concurrencyControl.run(() -> {
            PartitionTransitionStep nextPrepareStep = this.stepsToPrepare.pop();
            LOG.info(MSG_PREPARE_TRANSITION_STEP, new Object[]{this.context.getCurrentRole(), this.context.getCurrentTerm(), newRole, newTerm, nextPrepareStep.getName()});
            nextPrepareStep.prepareTransition(this.context, newTerm, newRole).onComplete((ok, error) -> this.onPrepareStepCompletion(future, (Throwable)error, newTerm, newRole));
        });
    }

    private void onPrepareStepCompletion(ActorFuture<Void> future, Throwable error, long newTerm, RaftServer.Role newRole) {
        if (error != null) {
            LOG.error(error.getMessage(), error);
            future.completeExceptionally(error);
            return;
        }
        if (this.stepsToPrepare.isEmpty()) {
            LOG.info(MSG_PREPARE_TRANSITION_COMPLETED, new Object[]{this.context.getCurrentRole(), this.context.getCurrentTerm(), newRole, newTerm});
            future.complete(null);
            return;
        }
        this.proceedWithPrepare(future, newTerm, newRole);
    }

    void cancel() {
        if (!this.completed) {
            LOG.info("Received cancel signal for transition to {} on term {}", (Object)this.role, (Object)this.term);
        }
        this.cancelRequested = true;
    }

    boolean isCompleted() {
        return this.completed;
    }

    public String toString() {
        return "PartitionTransitionProcess{term=" + this.term + ", role=" + String.valueOf(this.role) + ", cancelRequested=" + this.cancelRequested + ", completed=" + this.completed + ", stepsToPrepare=[" + this.stepsToPrepare.stream().map(PartitionTransitionStep::getName).collect(Collectors.joining(", ")) + "], pendingSteps=[" + this.pendingSteps.stream().map(PartitionTransitionStep::getName).collect(Collectors.joining(", ")) + "]}";
    }

    public HealthIssue getHealthIssue() {
        if (this.currentStep != null && ActorClock.currentTimeMillis() > this.stepStartedAtMs + STEP_TIMEOUT_MS) {
            return HealthIssue.of((String)"Transition from %s on term %s appears blocked, step %s has been running for %s".formatted(this.context.getCurrentRole(), this.context.getCurrentTerm(), this.currentStep.getName(), Duration.ofMillis(ActorClock.currentTimeMillis() - this.stepStartedAtMs)));
        }
        return null;
    }
}

