/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.backup.api.BackupManager;
import io.camunda.zeebe.backup.management.BackupService;
import io.camunda.zeebe.backup.management.NoopBackupManager;
import io.camunda.zeebe.backup.processing.CheckpointRecordsProcessor;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;

public final class BackupServiceTransitionStep
implements PartitionTransitionStep {
    @Override
    public ActorFuture<Void> prepareTransition(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        BackupManager backupManager = context.getBackupManager();
        if (backupManager != null && (this.shouldInstallOnTransition(targetRole, context.getCurrentRole()) || targetRole == RaftServer.Role.INACTIVE)) {
            ActorFuture closeFuture = backupManager.closeAsync();
            closeFuture.onComplete((ignore, error) -> {
                if (error == null) {
                    context.setBackupManager(null);
                    context.setCheckpointProcessor(null);
                }
            });
            return closeFuture;
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public ActorFuture<Void> transitionTo(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        ActorFuture installed = context.getConcurrencyControl().createFuture();
        if (this.shouldInstallOnTransition(targetRole, context.getCurrentRole()) || context.getBackupManager() == null && targetRole != RaftServer.Role.INACTIVE) {
            ActorFuture<Void> backupManagerInstalled = context.getBackupStore() == null ? BackupServiceTransitionStep.installNoopBackupManager(context, "No BackupStore is configured. Backup operations cannot be executed.") : (targetRole == RaftServer.Role.LEADER ? this.installBackupManager(context) : BackupServiceTransitionStep.installNoopBackupManager(context, "Broker is in follower role. Backup operations cannot be executed."));
            backupManagerInstalled.onComplete((ignore, error) -> {
                if (error == null) {
                    BackupServiceTransitionStep.installCheckpointProcessor(context, context.getBackupManager());
                    installed.complete(null);
                } else {
                    installed.completeExceptionally(error);
                }
            });
            return installed;
        }
        return context.getConcurrencyControl().createCompletedFuture();
    }

    @Override
    public String getName() {
        return "BackupManager";
    }

    private static ActorFuture<Void> installNoopBackupManager(PartitionTransitionContext context, String reasonForNoop) {
        NoopBackupManager backupManager = new NoopBackupManager(reasonForNoop);
        context.setBackupManager((BackupManager)backupManager);
        ActorFuture backupManagerInstalled = context.getConcurrencyControl().createCompletedFuture();
        return backupManagerInstalled;
    }

    private ActorFuture<Void> installBackupManager(PartitionTransitionContext context) {
        BackupService backupManager = new BackupService(context.getNodeId(), context.getPartitionId(), context.getBrokerCfg().getCluster().getPartitionsCount(), context.getBackupStore(), context.getPersistedSnapshotStore(), context.getRaftPartition().dataDirectory().toPath(), index -> context.getRaftPartition().getServer().getTailSegments(index), context.getPartitionTransitionMeterRegistry());
        ActorFuture installed = context.getConcurrencyControl().createFuture();
        context.getActorSchedulingService().submitActor((Actor)backupManager).onComplete((ignore, error) -> {
            if (error == null) {
                context.setBackupManager((BackupManager)backupManager);
                installed.complete(null);
            } else {
                installed.completeExceptionally(error);
            }
        });
        return installed;
    }

    private static void installCheckpointProcessor(PartitionTransitionContext context, BackupManager backupManager) {
        CheckpointRecordsProcessor checkpointRecordsProcessor = new CheckpointRecordsProcessor(backupManager, context.getPartitionId(), context.getPartitionTransitionMeterRegistry());
        context.setCheckpointProcessor(checkpointRecordsProcessor);
    }

    private boolean shouldInstallOnTransition(RaftServer.Role newRole, RaftServer.Role currentRole) {
        return newRole == RaftServer.Role.LEADER || newRole == RaftServer.Role.FOLLOWER && currentRole != RaftServer.Role.CANDIDATE || newRole == RaftServer.Role.CANDIDATE && currentRole != RaftServer.Role.FOLLOWER;
    }
}

